/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;

public class LatticeBlockEntity
extends BlockEntity {
    private int age = 0;
    private GrapeType grape = GrapeTypeRegistry.NONE;
    private boolean showHanging;
    private boolean initialized;

    public LatticeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.LATTICE.get(), pos, state);
    }

    public boolean shouldShowHanging() {
        return this.showHanging;
    }

    public void setAge(int age) {
        this.age = age;
        this.m_6596_();
        this.sync();
    }

    public int getAge() {
        return this.age;
    }

    public void setGrapeType(GrapeType grape) {
        this.grape = grape;
        if (!this.initialized && this.f_58857_ != null) {
            this.showHanging = this.f_58857_.f_46441_.m_188501_() < 0.15f;
            this.initialized = true;
        }
        this.m_6596_();
        this.sync();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.age = tag.m_128451_("Age");
        this.grape = GrapeType.fromString(tag.m_128461_("Grape"));
        this.showHanging = tag.m_128471_("ShowHanging");
        this.initialized = true;
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128405_("Age", this.age);
        tag.m_128359_("Grape", this.grape.m_7912_());
        tag.m_128379_("ShowHanging", this.showHanging);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

