/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.herbalbrews.core.blocks.entity.CauldronBlockEntity;
import net.satisfy.herbalbrews.core.blocks.entity.CompletionistBannerEntity;
import net.satisfy.herbalbrews.core.blocks.entity.DrinkBlockEntity;
import net.satisfy.herbalbrews.core.blocks.entity.JugBlockEntity;
import net.satisfy.herbalbrews.core.blocks.entity.StoveBlockEntity;
import net.satisfy.herbalbrews.core.blocks.entity.TeaKettleBlockEntity;
import net.satisfy.herbalbrews.core.blocks.entity.TeaLeafBlockEntity;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import net.satisfy.herbalbrews.core.util.HerbalBrewsIdentifier;

public class EntityTypeRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"herbalbrews", (ResourceKey)Registries.f_256922_);
    public static final RegistrySupplier<BlockEntityType<TeaKettleBlockEntity>> TEA_KETTLE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("tea_kettle", () -> BlockEntityType.Builder.m_155273_(TeaKettleBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.TEA_KETTLE.get(), (Block)ObjectRegistry.COPPER_TEA_KETTLE.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CauldronBlockEntity>> CAULDRON_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cauldron", () -> BlockEntityType.Builder.m_155273_(CauldronBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CAULDRON.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<TeaLeafBlockEntity>> TEA_LEAF_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("tea_leaf", () -> BlockEntityType.Builder.m_155273_(TeaLeafBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.GREEN_TEA_LEAF_BLOCK.get(), (Block)ObjectRegistry.MIXED_TEA_LEAF_BLOCK.get(), (Block)ObjectRegistry.DRIED_GREEN_TEA_LEAF_BLOCK.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> HERBALBREWS_BANNER = EntityTypeRegistry.registerBlockEntity("herbalbrews_banner", () -> BlockEntityType.Builder.m_155273_(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.HERBALBREWS_BANNER.get(), (Block)ObjectRegistry.HERBALBREWS_WALL_BANNER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<StoveBlockEntity>> STOVE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("stove_block_entity", () -> BlockEntityType.Builder.m_155273_(StoveBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.STOVE.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<JugBlockEntity>> JUG_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("jug_block_entity", () -> BlockEntityType.Builder.m_155273_(JugBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.JUG.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<DrinkBlockEntity>> DRINK_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("drink_block_entity", () -> BlockEntityType.Builder.m_155273_(DrinkBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.GREEN_TEA_BLOCK.get(), (Block)ObjectRegistry.COFFEE_BLOCK.get(), (Block)ObjectRegistry.BLACK_TEA_BLOCK.get(), (Block)ObjectRegistry.LAVENDER_TEA_BLOCK.get(), (Block)ObjectRegistry.YERBA_MATE_TEA_BLOCK.get(), (Block)ObjectRegistry.OOLONG_TEA_BLOCK.get(), (Block)ObjectRegistry.ROOIBOS_TEA_BLOCK.get(), (Block)ObjectRegistry.HIBISCUS_TEA_BLOCK.get(), (Block)ObjectRegistry.MILK_COFFEE_BLOCK.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String name, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new HerbalBrewsIdentifier(name), type);
    }

    public static void init() {
        BLOCK_ENTITY_TYPES.register();
    }
}

