/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.items;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.satisfy.herbalbrews.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class HatItem
extends ArmorItem {
    private final ResourceLocation hatTexture;

    public HatItem(ArmorMaterial armorMaterial, ArmorItem.Type type, Item.Properties properties, ResourceLocation hatTexture) {
        super(armorMaterial, type, properties);
        this.hatTexture = hatTexture;
    }

    public ResourceLocation getHatTexture() {
        return this.hatTexture;
    }

    @NotNull
    public EquipmentSlot m_40402_() {
        return this.f_265916_.m_266308_();
    }

    public static void applyMagicResistance(LivingEntity entity, float damageAmount, boolean isMagic) {
        Player player;
        ItemStack helmet;
        if (entity instanceof Player && (helmet = (player = (Player)entity).m_6844_(EquipmentSlot.HEAD)).m_41720_() instanceof HatItem && isMagic && PlatformHelper.isHatDamageReductionEnabled()) {
            float reduction = (float)PlatformHelper.getHatDamageReductionAmount() / 100.0f;
            float reducedDamage = damageAmount * (1.0f - reduction);
            entity.m_21153_(entity.m_21223_() + (damageAmount - reducedDamage));
        }
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (PlatformHelper.isHatDamageReductionEnabled()) {
            int reductionAmount = PlatformHelper.getHatDamageReductionAmount();
            MutableComponent magicDamage = Component.m_237115_((String)"tooltip.herbalbrews.magic_damage").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#AA00FF")));
            MutableComponent damageReduction = Component.m_237110_((String)"tooltip.herbalbrews.damage_reduction", (Object[])new Object[]{magicDamage, reductionAmount + "%"});
            tooltip.add((Component)damageReduction);
        }
    }
}

