/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.entity.ai;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.block.PetBowlBlock;
import net.satisfy.farm_and_charm.core.block.entity.PetBowlBlockEntity;
import net.satisfy.farm_and_charm.core.entity.BowlAccessor;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.joml.Vector3f;

public class DogEatFromBowlGoal
extends Goal {
    private final Wolf dog;
    private BlockPos targetBowl;
    private Vector3f targetVec;
    private int eatTicks;
    private ItemStack foodStack;

    public DogEatFromBowlGoal(Wolf dog) {
        this.dog = dog;
    }

    public boolean m_8036_() {
        if (!this.dog.m_21824_() || this.dog.m_21827_()) {
            return false;
        }
        Level level = this.dog.m_9236_();
        BlockPos dogPos = this.dog.m_20183_();
        double closestDist = Double.MAX_VALUE;
        BlockPos closest = null;
        ItemStack candidateFood = ItemStack.f_41583_;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)dogPos.m_7918_(-16, -4, -16), (BlockPos)dogPos.m_7918_(16, 4, 16))) {
            double dist;
            PetBowlBlockEntity bowl;
            BlockEntity be;
            BlockState state = level.m_8055_(pos);
            if (!state.m_60713_((Block)ObjectRegistry.PET_BOWL.get()) || !state.m_61138_(PetBowlBlock.FOOD_TYPE) || state.m_61143_(PetBowlBlock.FOOD_TYPE) != GeneralUtil.FoodType.DOG || !((be = level.m_7702_(pos)) instanceof PetBowlBlockEntity) || (bowl = (PetBowlBlockEntity)be).m_7983_() || !bowl.canBeUsedBy((Animal)this.dog) || !((dist = pos.m_123331_((Vec3i)dogPos)) < closestDist)) continue;
            closestDist = dist;
            closest = pos.m_7949_();
            candidateFood = bowl.m_8020_(0).m_41777_();
        }
        if (closest != null) {
            this.targetBowl = closest;
            this.targetVec = new Vector3f((float)closest.m_123341_() + 0.5f, (float)closest.m_123342_(), (float)closest.m_123343_() + 0.5f);
            this.foodStack = candidateFood;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        this.dog.m_21573_().m_26519_((double)this.targetVec.x(), (double)this.targetVec.y(), (double)this.targetVec.z(), 1.0);
        this.eatTicks = 0;
    }

    public boolean m_8045_() {
        PetBowlBlockEntity bowl;
        if (this.targetBowl == null) {
            return false;
        }
        Level level = this.dog.m_9236_();
        BlockState state = level.m_8055_(this.targetBowl);
        if (!(state.m_60734_() instanceof PetBowlBlock) || !state.m_61138_(PetBowlBlock.FOOD_TYPE)) {
            return false;
        }
        BlockEntity be = level.m_7702_(this.targetBowl);
        if (!(be instanceof PetBowlBlockEntity) || (bowl = (PetBowlBlockEntity)be).m_7983_() || !bowl.canBeUsedBy((Animal)this.dog)) {
            return false;
        }
        float distSqr = this.targetVec.distanceSquared((float)this.dog.m_20185_(), (float)this.dog.m_20186_(), (float)this.dog.m_20189_());
        return distSqr > 4.0f || this.eatTicks < 60;
    }

    public void m_8037_() {
        PetBowlBlockEntity bowl;
        if (this.targetBowl == null) {
            this.m_8041_();
            return;
        }
        Level level = this.dog.m_9236_();
        BlockEntity be = level.m_7702_(this.targetBowl);
        if (!(be instanceof PetBowlBlockEntity) || (bowl = (PetBowlBlockEntity)be).m_7983_()) {
            this.m_8041_();
            return;
        }
        float distSqr = this.targetVec.distanceSquared((float)this.dog.m_20185_(), (float)this.dog.m_20186_(), (float)this.dog.m_20189_());
        if (distSqr <= 4.0f) {
            ++this.eatTicks;
            this.dog.m_21839_(true);
            this.dog.m_21563_().m_24946_((double)this.targetVec.x(), (double)this.targetVec.y(), (double)this.targetVec.z());
            if (!level.f_46443_ && this.eatTicks <= 40) {
                ParticleOptions particle = this.getParticleFromFood();
                if (particle != null) {
                    ((ServerLevel)level).m_8767_(particle, (double)this.targetVec.x(), (double)(this.targetVec.y() + 0.09375f), (double)this.targetVec.z(), 3, 0.2, 0.2, 0.2, 0.05);
                }
                if (this.eatTicks % 10 == 0) {
                    level.m_5594_(null, this.dog.m_20183_(), SoundEvents.f_12619_, SoundSource.NEUTRAL, 0.4f, 0.4f);
                }
            }
            if (this.eatTicks == 40) {
                bowl.decreaseFood();
                ((BowlAccessor.StayNearBowl)this.dog).farmAndCharm$setStayCenter(this.targetBowl);
                if (!level.f_46443_) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.dog.m_20185_(), this.dog.m_20186_() + 0.5, this.dog.m_20189_(), 3, 0.3, 0.3, 0.3, 0.01);
                    level.m_5594_(null, this.dog.m_20183_(), SoundEvents.f_12620_, this.dog.m_5720_(), 0.4f, 0.4f);
                    BlockState old = level.m_8055_(this.targetBowl);
                    if (old.m_60734_() instanceof PetBowlBlock && old.m_61138_(PetBowlBlock.FOOD_TYPE)) {
                        level.m_46597_(this.targetBowl, (BlockState)old.m_61124_(PetBowlBlock.FOOD_TYPE, (Comparable)((Object)GeneralUtil.FoodType.NONE)));
                    }
                }
            }
        }
    }

    public void m_8041_() {
        this.targetBowl = null;
        this.targetVec = null;
        this.eatTicks = 0;
        this.foodStack = null;
        this.dog.m_21839_(false);
    }

    private ParticleOptions getParticleFromFood() {
        if (this.foodStack == null || this.foodStack.m_41619_()) {
            return null;
        }
        return new ItemParticleOption(ParticleTypes.f_123752_, this.foodStack);
    }
}

