/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.compat.rei.cooking;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.satisfy.farm_and_charm.core.recipe.CookingPotRecipe;

public class CookingPotDisplay
extends BasicDisplay {
    public static final CategoryIdentifier<CookingPotDisplay> COOKING_POT_DISPLAY = CategoryIdentifier.of((String)"farm_and_charm", (String)"cooking_pot_display");

    public CookingPotDisplay(Recipe<Container> recipe) {
        this(CookingPotDisplay.createInputs(recipe), CookingPotDisplay.createOutputs(recipe), CookingPotDisplay.getLocation(recipe));
    }

    private static List<EntryIngredient> createInputs(Recipe<Container> recipe) {
        CookingPotRecipe c;
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>();
        ItemStack container = CookingPotDisplay.getContainer(recipe);
        int ingredientIndex = 0;
        for (Ingredient ingredient : recipe.m_7527_()) {
            for (ItemStack stack : ingredient.m_43908_()) {
                if (ingredientIndex >= 6) continue;
                inputs.add(EntryIngredients.of((ItemStack)stack));
                ++ingredientIndex;
            }
        }
        while (inputs.size() < 6) {
            inputs.add(EntryIngredients.of((ItemStack)new ItemStack((ItemLike)Items.f_41852_)));
        }
        if (recipe instanceof CookingPotRecipe && (c = (CookingPotRecipe)recipe).isContainerRequired() && !c.getContainerItem().m_41619_()) {
            inputs.add(EntryIngredients.of((ItemStack)c.getContainerItem()));
        } else {
            inputs.add(EntryIngredients.of((ItemStack)new ItemStack((ItemLike)Items.f_41852_)));
        }
        return inputs;
    }

    private static List<EntryIngredient> createOutputs(Recipe<Container> recipe) {
        RegistryAccess.Frozen registryAccess = Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.m_9598_() : RegistryAccess.f_243945_;
        ItemStack result = recipe.m_8043_((RegistryAccess)registryAccess);
        return List.of(EntryIngredients.of((ItemStack)result));
    }

    private static Optional<ResourceLocation> getLocation(Recipe<Container> recipe) {
        return Optional.of(recipe.m_6423_());
    }

    public CookingPotDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location) {
        super(inputs, outputs, location);
    }

    public static ItemStack getContainer(Recipe<Container> recipe) {
        if (recipe instanceof CookingPotRecipe) {
            CookingPotRecipe c = (CookingPotRecipe)recipe;
            return c.getContainerItem();
        }
        return ItemStack.f_41583_;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return COOKING_POT_DISPLAY;
    }
}

