/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.client.BreweryClient;
import net.satisfy.brewery.core.block.entity.WallDecorationBlockEntity;
import net.satisfy.farm_and_charm.core.block.FacingBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallDecorationBlock
extends FacingBlock
implements EntityBlock {
    private static final Map<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)));

    public WallDecorationBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return WallDecorationBlock.getBoundingShape(state);
    }

    public static VoxelShape getBoundingShape(BlockState state) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)f_54117_));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        for (Direction direction : ctx.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)direction.m_122424_())).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122424_() == state.m_61143_((Property)f_54117_) && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WallDecorationBlockEntity) {
            WallDecorationBlockEntity signEntity = (WallDecorationBlockEntity)blockEntity;
            if (heldItem.m_150930_(Items.f_151056_)) {
                if (!signEntity.isGlowing()) {
                    signEntity.setGlowing(true);
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (level.f_46443_) {
                BreweryClient.openStreetSignScreen(signEntity);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WallDecorationBlockEntity(pos, state);
    }
}

