/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.core.block.BrewingstationBlock;
import net.satisfy.brewery.core.block.property.BrewMaterial;
import net.satisfy.brewery.core.registry.BlockStateRegistry;
import net.satisfy.brewery.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class BrewWhistleBlock
extends BrewingstationBlock {
    public static final BooleanProperty WHISTLE = BlockStateRegistry.WHISTLE;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE;
    public static final Map<Direction, VoxelShape> TOP_SHAPE;
    private static final Supplier<VoxelShape> bottomVoxelShapeSupplier;
    private static final Supplier<VoxelShape> topVoxelShapeSupplier;
    private long lastSoundTime = 0L;

    public BrewWhistleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)MATERIAL, (Comparable)((Object)BrewMaterial.WOOD))).m_61124_((Property)WHISTLE, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            level.m_46597_(blockPos.m_7494_(), (BlockState)blockState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALF) != doubleBlockHalf ? (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)((Direction)blockState2.m_61143_((Property)f_54117_))) : Blocks.f_50016_.m_49966_();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !blockState.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Override
    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (((DoubleBlockHalf)blockState.m_61143_(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            blockPos = blockPos.m_7495_();
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    @Override
    @NotNull
    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        if (((DoubleBlockHalf)blockState.m_61143_(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            blockPos = blockPos.m_7495_();
        }
        return super.m_7397_(blockGetter, blockPos, blockState);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Map<Direction, VoxelShape> shapeMap = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? BOTTOM_SHAPE : TOP_SHAPE;
        return shapeMap.get(state.m_61143_((Property)f_54117_));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WHISTLE, HALF});
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (!((Boolean)state.m_61143_((Property)WHISTLE)).booleanValue()) {
            return;
        }
        if (state.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        double offsetX = 0.5 + (double)direction.m_122429_() * 0.6;
        double offsetY = 0.8;
        double offsetZ = 0.5 + (double)direction.m_122431_() * 0.6;
        double x = (double)pos.m_123341_() + offsetX;
        double y = (double)pos.m_123342_() + offsetY;
        double z = (double)pos.m_123343_() + offsetZ;
        double speedX = (double)direction.m_122429_() * 0.1 + ((double)rand.m_188501_() - 0.5) * 0.05;
        double speedY = 0.5;
        double speedZ = (double)direction.m_122431_() * 0.1 + ((double)rand.m_188501_() - 0.5) * 0.05;
        for (int i = 0; i < 5; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, speedX, speedY, speedZ);
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSoundTime >= 3000L) {
            world.m_7785_(x, y, z, (SoundEvent)SoundEventRegistry.BREWSTATION_WHISTLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            this.lastSoundTime = currentTime;
        }
    }

    static {
        bottomVoxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.125));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.125, (double)0.125, (double)1.0, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)1.0, (double)0.125, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.9375, (double)0.125, (double)1.0, (double)1.0, (double)1.0));
            return shape;
        };
        topVoxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.25, (double)0.4375, (double)1.0, (double)0.5));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5, (double)0.1875, (double)0.5, (double)0.5625, (double)0.5625));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.875, (double)0.1875, (double)0.5, (double)0.9375, (double)0.5625));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.5, (double)0.5625, (double)0.5, (double)0.75, (double)0.625));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.15625, (double)0.59375, (double)0.21875, (double)0.46875, (double)0.84375, (double)0.53125));
            return shape;
        };
        BOTTOM_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)bottomVoxelShapeSupplier.get()));
            }
        });
        TOP_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)topVoxelShapeSupplier.get()));
            }
        });
    }
}

