/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.core.block.BigBarrelBlock;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigBarrelMainBlock
extends BigBarrelBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF;
    private static final Supplier<VoxelShape> bottomVoxelShapeSupplier;
    public static final Map<Direction, VoxelShape> BOTTOM_SHAPE;
    private static final Supplier<VoxelShape> topVoxelShapeSupplier;
    public static final Map<Direction, VoxelShape> TOP_SHAPE;

    public BigBarrelMainBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            level.m_46597_(blockPos.m_7494_(), (BlockState)blockState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)blockState.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return blockState2.m_60713_((Block)this) && blockState2.m_61143_(HALF) != doubleBlockHalf ? (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)((Direction)blockState2.m_61143_((Property)f_54117_))) : Blocks.f_50016_.m_49966_();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !blockState.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
        BlockPos backPos = blockPos.m_121945_(facing.m_122424_());
        BlockPos sidePos = blockPos.m_121945_(facing.m_122428_());
        BlockPos diagonalPos = sidePos.m_121945_(facing.m_122424_());
        level.m_7471_(backPos, false);
        level.m_7471_(sidePos, false);
        level.m_7471_(diagonalPos, false);
        level.m_7471_(blockPos, false);
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.m_43725_();
        BlockPos mainPos = blockPlaceContext.m_8083_();
        BlockState blockState = super.m_5573_(blockPlaceContext);
        if (blockState == null) {
            return null;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
        BlockPos backPos = mainPos.m_121945_(facing.m_122424_());
        BlockPos sidePos = mainPos.m_121945_(facing.m_122428_());
        BlockPos diagonalPos = sidePos.m_121945_(facing.m_122424_());
        BlockPos topPos = diagonalPos.m_7494_();
        boolean placeable = this.canPlace(level, backPos, sidePos, diagonalPos, topPos);
        return placeable ? blockState : null;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        if (level.f_46443_) {
            return;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
        BlockPos backPos = blockPos.m_121945_(facing.m_122424_());
        BlockPos sidePos = blockPos.m_121945_(facing.m_122428_());
        BlockPos diagonalPos = sidePos.m_121945_(facing.m_122424_());
        BlockPos topPos = diagonalPos.m_7494_();
        if (!this.canPlace(level, backPos, sidePos, diagonalPos, topPos)) {
            return;
        }
        level.m_7731_(backPos, (BlockState)((Block)ObjectRegistry.BARREL_MAIN_HEAD.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)facing), 3);
        level.m_7731_(sidePos, (BlockState)((Block)ObjectRegistry.BARREL_RIGHT.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)facing), 3);
        level.m_7731_(diagonalPos, (BlockState)((Block)ObjectRegistry.BARREL_HEAD_RIGHT.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)facing), 3);
    }

    private boolean canPlace(Level level, BlockPos ... blockPoses) {
        for (BlockPos blockPos : blockPoses) {
            if (level.m_8055_(blockPos).m_60795_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        if (half == DoubleBlockHalf.LOWER) {
            return BOTTOM_SHAPE.get(facing);
        }
        return TOP_SHAPE.get(facing);
    }

    static {
        bottomVoxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.1875, (double)0.875, (double)0.25, (double)0.4375));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0, (double)0.875, (double)1.0, (double)1.0));
            return shape;
        };
        BOTTOM_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)bottomVoxelShapeSupplier.get()));
            }
        });
        topVoxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0));
            return shape;
        };
        TOP_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)topVoxelShapeSupplier.get()));
            }
        });
        HALF = BlockStateProperties.f_61401_;
    }
}

