/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.warn;

import com.example.junctionmod.warn.WarnConfig;
import com.example.junctionmod.warn.Warning;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;

public class WarnManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<Warning> warnings = new ArrayList<Warning>();
    private static Path savePath;

    public static void init(MinecraftServer server) {
        savePath = server.m_129843_(LevelResource.f_78182_).resolve("junction_warns.json");
        WarnManager.load();
    }

    public static void addWarn(ServerPlayer sender, String targetUuid, String targetName, String reason, MinecraftServer server) {
        int newId = warnings.stream().mapToInt(w -> w.id).max().orElse(0) + 1;
        String senderName = sender != null ? sender.m_36316_().getName() : "Console";
        Warning warning = new Warning(newId, targetUuid, targetName, senderName, reason);
        warnings.add(warning);
        WarnManager.save();
        ServerPlayer targetPlayer = server.m_6846_().m_11259_(UUID.fromString(targetUuid));
        long activeCount = WarnManager.getActiveWarnsCount(targetUuid);
        int maxWarns = (Integer)WarnConfig.MAX_WARNS.get();
        if (targetPlayer != null) {
            targetPlayer.m_213846_((Component)Component.m_237113_((String)"\u00a7c[Junction] \u00a7e\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435!"));
            targetPlayer.m_213846_((Component)Component.m_237113_((String)("\u00a77\u041f\u0440\u0438\u0447\u0438\u043d\u0430: \u00a7f" + reason)));
            targetPlayer.m_213846_((Component)Component.m_237113_((String)("\u00a77\u0421\u0442\u0430\u0442\u0443\u0441: \u00a7c" + activeCount + "/" + maxWarns)));
        }
        if (activeCount >= (long)maxWarns) {
            WarnManager.executePunishment(server, targetName, targetUuid);
        }
    }

    public static boolean removeWarn(int id) {
        Warning w = WarnManager.getWarningById(id);
        if (w != null) {
            warnings.remove(w);
            WarnManager.save();
            return true;
        }
        return false;
    }

    public static List<Warning> getPlayerWarnings(String uuid) {
        WarnManager.checkExpirations();
        return warnings.stream().filter(w -> w.targetUuid.equals(uuid) && w.active).collect(Collectors.toList());
    }

    public static List<Warning> getAllWarnings() {
        return new ArrayList<Warning>(warnings);
    }

    private static Warning getWarningById(int id) {
        return warnings.stream().filter(w -> w.id == id).findFirst().orElse(null);
    }

    private static long getActiveWarnsCount(String uuid) {
        WarnManager.checkExpirations();
        return warnings.stream().filter(w -> w.targetUuid.equals(uuid) && w.active).count();
    }

    private static void checkExpirations() {
        int hours = (Integer)WarnConfig.WARN_EXPIRE_HOURS.get();
        if (hours <= 0) {
            return;
        }
        long expirationTime = (long)hours * 3600000L;
        long now = System.currentTimeMillis();
        boolean changed = false;
        for (Warning w : warnings) {
            if (!w.active || now - w.timestamp <= expirationTime) continue;
            w.active = false;
            changed = true;
        }
        if (changed) {
            WarnManager.save();
        }
    }

    private static void executePunishment(MinecraftServer server, String playerName, String uuid) {
        String command = ((String)WarnConfig.PUNISH_COMMAND.get()).replace("{player}", playerName);
        LOGGER.info("Executing punishment for {}: {}", (Object)playerName, (Object)command);
        server.m_129892_().m_230957_(server.m_129893_(), command);
        if (((Boolean)WarnConfig.RESET_AFTER_PUNISH.get()).booleanValue()) {
            warnings.stream().filter(w -> w.targetUuid.equals(uuid) && w.active).forEach(w -> {
                w.active = false;
            });
            WarnManager.save();
        }
    }

    private static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(savePath, new OpenOption[0]);){
            GSON.toJson(warnings, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save warnings", (Throwable)e);
        }
    }

    private static void load() {
        if (!Files.exists(savePath, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(savePath);){
            List loaded = (List)GSON.fromJson((Reader)reader, new TypeToken<List<Warning>>(){}.getType());
            if (loaded != null) {
                warnings.clear();
                warnings.addAll(loaded);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load warnings", (Throwable)e);
        }
    }
}

