/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.warn;

import com.example.junctionmod.warn.WarnManager;
import com.example.junctionmod.warn.Warning;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class WarnCommands {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"j_warn").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)GameProfileArgument.m_94584_()).then(Commands.m_82129_((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(WarnCommands::executeWarn))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"j_warninfo").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"target", (ArgumentType)GameProfileArgument.m_94584_()).executes(WarnCommands::executeWarnInfo)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"j_warnlist").requires(source -> source.m_6761_(2))).executes(ctx -> WarnCommands.executeWarnList((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> WarnCommands.executeWarnList((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"j_unwarn").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"id", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(WarnCommands::executeUnwarn)));
    }

    private static int executeWarn(CommandContext<CommandSourceStack> ctx) {
        try {
            Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"target");
            String reason = StringArgumentType.getString(ctx, (String)"reason");
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerPlayer sender = source.m_230897_() ? source.m_230896_() : null;
            for (GameProfile profile : profiles) {
                WarnManager.addWarn(sender, profile.getId().toString(), profile.getName(), reason, source.m_81377_());
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7a[Junction] \u00a7f\u0412\u0430\u0440\u043d \u0432\u044b\u0434\u0430\u043d \u0438\u0433\u0440\u043e\u043a\u0443 \u00a7e" + profile.getName() + "\u00a7f.")), true);
            }
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0434\u0430\u0447\u0435 \u0432\u0430\u0440\u043d\u0430: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeWarnInfo(CommandContext<CommandSourceStack> ctx) {
        try {
            Collection profiles = GameProfileArgument.m_94590_(ctx, (String)"target");
            GameProfile profile = (GameProfile)profiles.iterator().next();
            List<Warning> warnings = WarnManager.getPlayerWarnings(profile.getId().toString());
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a76--- \u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f \u0438\u0433\u0440\u043e\u043a\u0430 " + profile.getName() + " (" + warnings.size() + ") ---")));
            for (Warning w : warnings) {
                String date = DATE_FORMAT.format(new Date(w.timestamp));
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)String.format("\u00a77[ID:%d] \u00a7f| \u041c\u043e\u0434\u0435\u0440: \u00a7b%s \u00a7f| \u041f\u0440\u0438\u0447\u0438\u043d\u0430: \u00a7c%s \u00a7f| \u0414\u0430\u0442\u0430: \u00a77%s", w.id, w.senderName, w.reason, date)));
            }
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int executeWarnList(CommandContext<CommandSourceStack> ctx, int page) {
        List<Warning> all = WarnManager.getAllWarnings();
        Collections.reverse(all);
        int itemsPerPage = 10;
        int totalPages = (int)Math.ceil((double)all.size() / (double)itemsPerPage);
        if (totalPages == 0) {
            totalPages = 1;
        }
        if (page > totalPages) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 " + page + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430. \u0412\u0441\u0435\u0433\u043e \u0441\u0442\u0440\u0430\u043d\u0438\u0446: " + totalPages)));
            return 0;
        }
        int start = (page - 1) * itemsPerPage;
        int end = Math.min(start + itemsPerPage, all.size());
        ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a76--- \u0412\u0441\u0435 \u043f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f (\u0421\u0442\u0440. " + page + "/" + totalPages + ") ---")));
        for (int i = start; i < end; ++i) {
            Warning w = all.get(i);
            String status = w.active ? "\u00a7a[\u0410\u043a\u0442\u0438\u0432\u0435\u043d]" : "\u00a78[\u0421\u043d\u044f\u0442]";
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)String.format("\u00a77#%d %s \u00a7e%s \u00a77-> \u00a7e%s\u00a77: %s", w.id, status, w.senderName, w.targetName, w.reason)));
        }
        if (page < totalPages) {
            ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)("\u00a77\u0414\u043b\u044f \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b: \u00a7b/j_warnlist " + (page + 1))));
        }
        return 1;
    }

    private static int executeUnwarn(CommandContext<CommandSourceStack> ctx) {
        int id = IntegerArgumentType.getInteger(ctx, (String)"id");
        boolean removed = WarnManager.removeWarn(id);
        if (removed) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a[Junction] \u00a7f\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 #" + id + " \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e.")), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0441 ID " + id + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.")));
        return 0;
    }
}

