/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.vorial;

import com.example.junctionmod.Atercenite.AterceniteManager;
import com.example.junctionmod.ModRegistry;
import com.example.junctionmod.effect.ModMobEffects;
import com.example.junctionmod.event.GlobalEventManager;
import com.example.junctionmod.event.GlobalEventType;
import com.example.junctionmod.tertserskill.ITertserSkill;
import com.example.junctionmod.tertserskill.TertserSkill;
import com.example.junctionmod.vorial.VorialCapability;
import com.example.junctionmod.vorial.VorialNetwork;
import com.example.junctionmod.vorial.VorialSyncPacket;
import com.example.junctionmod.world.ModDimensions;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="junctionmod")
public class VorialTick {
    private static final Capability<ITertserSkill> SKILL_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITertserSkill>(){});
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer() && event.level.m_46472_() == Level.f_46428_) {
            GlobalEventManager.get((ServerLevel)event.level).tick((ServerLevel)event.level);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.player.m_9236_().f_46443_) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        ServerLevel level = (ServerLevel)player.m_9236_();
        GlobalEventManager events = GlobalEventManager.get(level);
        ResourceKey currentDim = level.m_46472_();
        if (player.f_19797_ % 10 == 0) {
            boolean isInField = AterceniteManager.isPlayerInField(player);
            player.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                if (cap.isSuppressed() != isInField) {
                    cap.setSuppressed(isInField);
                    VorialTick.syncVorial(player, cap);
                }
            });
        }
        if (player.f_19797_ % 20 == 0 && events.isEventActive(GlobalEventType.GREAT_FROST) && currentDim.equals(ModDimensions.HELHEIM) && random.nextFloat() < 0.002f) {
            VorialTick.spawnFrostCrystal(level, player);
        }
        if (player.f_19797_ % 40 == 0 && events.isSolarFlareActive() && currentDim.equals(ModDimensions.AMENTI)) {
            VorialTick.handleSolarFlareDamage(player, level);
        }
        VorialTick.handleAudioAndPassiveEffects(player, level);
        if (player.f_19797_ % 60 == 0) {
            VorialTick.handleVorialRegeneration(player, level, events, currentDim.m_135782_().toString());
        }
    }

    private static void handleVorialRegeneration(ServerPlayer player, ServerLevel level, GlobalEventManager events, String currentDimId) {
        if (player.m_21023_((MobEffect)ModMobEffects.SPARK_EXHAUSTION.get())) {
            return;
        }
        player.getCapability(VorialCapability.INSTANCE).ifPresent(vorialCap -> {
            if (vorialCap.isSuppressed()) {
                return;
            }
            player.getCapability(SKILL_CAP).ifPresent(skill -> {
                int baseMax = TertserSkill.getMaxVorialForLevel(skill.getCurrentLevel());
                int currentVorial = vorialCap.getVorial();
                int targetMax = baseMax;
                float regenChance = 1.0f;
                int regenAmount = 1;
                if (events.isVoidCallActive() && currentDimId.equals(ModDimensions.asString(ModDimensions.NOON))) {
                    targetMax = baseMax * 2;
                    if (targetMax < 400) {
                        targetMax = 400;
                    }
                    regenChance = 0.75f;
                }
                if (events.isEventActive(GlobalEventType.GREAT_FROST)) {
                    regenChance = currentDimId.equals(ModDimensions.asString(ModDimensions.HELHEIM)) ? 0.0f : 0.5f;
                }
                if (events.isEventActive(GlobalEventType.VORIAL_TIDES)) {
                    float multiplier = events.getVorialRegenMultiplier(currentDimId);
                    if (multiplier > 1.0f) {
                        regenAmount = (int)multiplier;
                    } else if (multiplier < 1.0f) {
                        regenChance *= multiplier;
                    }
                }
                if (currentVorial > targetMax) {
                    vorialCap.setVorial(currentVorial - 1);
                    VorialTick.syncVorial(player, vorialCap);
                } else if (currentVorial < targetMax && regenChance > 0.0f && random.nextFloat() < regenChance) {
                    int newVal = Math.min(currentVorial + regenAmount, targetMax);
                    vorialCap.setVorial(newVal);
                    VorialTick.syncVorial(player, vorialCap);
                }
            });
        });
    }

    private static void handleSolarFlareDamage(ServerPlayer player, ServerLevel level) {
        if (!level.m_46461_() || !level.m_45527_(player.m_20183_())) {
            return;
        }
        BlockPos pos = player.m_20183_();
        for (BlockPos p : BlockPos.m_121940_((BlockPos)pos.m_7918_(-2, -1, -2), (BlockPos)pos.m_7918_(2, 2, 2))) {
            if (!level.m_8055_(p).m_60713_((Block)ModRegistry.ATERCENITE_BLOCK.get()) && !level.m_8055_(p).m_60713_(Blocks.f_50354_)) continue;
            return;
        }
        player.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> player.getCapability(SKILL_CAP).ifPresent(skill -> {
            int max = TertserSkill.getMaxVorialForLevel(skill.getCurrentLevel());
            if (max <= 0) {
                return;
            }
            float ratio = (float)cap.getVorial() / (float)max;
            if (ratio <= 0.1f) {
                return;
            }
            float damage = (ratio - 0.1f) * 8.0f;
            if (damage > 0.0f) {
                player.m_6469_(level.m_269111_().m_269387_(), damage);
                player.m_20254_(3);
            }
        }));
    }

    private static void handleAudioAndPassiveEffects(ServerPlayer player, ServerLevel level) {
        if (player.f_19797_ % 60 == 0) {
            player.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                if (cap.isSuppressed()) {
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_11768_, SoundSource.BLOCKS, 0.4f, 0.5f);
                }
            });
        }
        if (player.f_19797_ % 20 == 0 && player.m_21023_((MobEffect)ModMobEffects.EXILE_MARK.get()) && random.nextInt(10) == 0) {
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12404_, SoundSource.AMBIENT, 0.6f, 0.8f);
        }
        if (player.m_21023_((MobEffect)ModMobEffects.VORIAL_CASCADE.get())) {
            player.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> player.getCapability(SKILL_CAP).ifPresent(skill -> {
                int max = TertserSkill.getMaxVorialForLevel(skill.getCurrentLevel());
                if (cap.getVorial() < max) {
                    cap.setVorial(max);
                    if (player.f_19797_ % 5 == 0) {
                        VorialTick.syncVorial(player, cap);
                    }
                }
            }));
        }
        if (player.f_19797_ % 10 == 0) {
            player.getCapability(SKILL_CAP).ifPresent(skill -> {
                if (skill.isMadnessActive()) {
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123799_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 3, 0.3, 0.5, 0.3, 0.02);
                    if (player.f_19797_ % 40 == 0) {
                        level.m_5594_(null, player.m_20183_(), SoundEvents.f_276532_, SoundSource.PLAYERS, 0.5f, 0.5f);
                    }
                }
            });
        }
    }

    private static void spawnFrostCrystal(ServerLevel level, ServerPlayer player) {
        int cx = player.m_20183_().m_123341_() + (random.nextInt(32) - 16);
        int cz = player.m_20183_().m_123343_() + (random.nextInt(32) - 16);
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, cx, cz);
        int cy = Math.min(surfaceY + 15, level.m_151558_());
        ItemStack stack = new ItemStack((ItemLike)ModRegistry.CRYSTALLIZED_VORIAL_ITEM.get());
        stack.m_41784_().m_128405_("MeltTimer", 0);
        ItemEntity item = new ItemEntity((Level)level, (double)cx + 0.5, (double)cy, (double)cz + 0.5, stack);
        item.m_20242_(false);
        item.m_20334_(random.nextGaussian() * 0.1, -0.2, random.nextGaussian() * 0.1);
        level.m_7967_((Entity)item);
        level.m_6263_(null, (double)cx, (double)cy, (double)cz, SoundEvents.f_144243_, SoundSource.WEATHER, 2.0f, 0.5f);
    }

    private static void syncVorial(ServerPlayer player, VorialCapability cap) {
        VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new VorialSyncPacket(cap.getVorial(), cap.isSuppressed()));
    }
}

