/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.vorial;

import com.example.junctionmod.client.ClientPayloadHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class VorialSyncPacket {
    private final int vorial;
    private final boolean isSuppressed;

    public VorialSyncPacket(int vorial, boolean isSuppressed) {
        this.vorial = vorial;
        this.isSuppressed = isSuppressed;
    }

    public int getVorial() {
        return this.vorial;
    }

    public boolean isSuppressed() {
        return this.isSuppressed;
    }

    public static void encode(VorialSyncPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.vorial);
        buf.writeBoolean(msg.isSuppressed);
    }

    public static VorialSyncPacket decode(FriendlyByteBuf buf) {
        return new VorialSyncPacket(buf.readInt(), buf.readBoolean());
    }

    public static void handle(VorialSyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPayloadHandler.handleVorialSync(msg)));
        ctx.get().setPacketHandled(true);
    }
}

