/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.vorial;

import com.example.junctionmod.event.GlobalEventType;
import com.example.junctionmod.vorial.ClientEventData;
import com.example.junctionmod.vorial.VorialCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="junctionmod", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class VorialHud {
    private static final ResourceLocation ICONS = ResourceLocation.m_135820_((String)"textures/gui/icons.png");
    private static float time = 0.0f;
    private static final IGuiOverlay VORIAL_BAR = (gui, graphics, partialTick, screenWidth, screenHeight) -> {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        time += partialTick * 0.2f;
        boolean isSolarFlare = ClientEventData.currentEvent == GlobalEventType.SOLAR_FLARE;
        mc.f_91074_.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
            boolean isSuppressed = cap.isSuppressed();
            int current = cap.getVorial();
            int max = VorialCapability.getMaxVorial((Player)mc.f_91074_);
            float percent = Math.max(0.0f, Math.min(1.0f, (float)current / (float)max));
            int XP_FULL_WIDTH = 182;
            int barWidth = 91;
            int barHeight = 5;
            int x = screenWidth / 2 - 91 - 91 - 10;
            int y = screenHeight - 29;
            graphics.m_280218_(ICONS, x, y, 0, 64, 91, 5);
            if (isSuppressed) {
                int baseGray = 657930;
                int darkGray = 0x1A1A1A;
                int steelGray = 0x444444;
                float breathSpeed = 0.05f;
                float breath = (float)(Math.sin((double)(time * breathSpeed) * Math.PI * 2.0) * 0.5 + 0.5);
                float darkness = Mth.m_14179_((float)breath, (float)0.65f, (float)0.9f);
                int bgColor = (int)(220.0f * darkness) << 24 | baseGray;
                graphics.m_280509_(x, y, x + 91, y + 5, bgColor);
                float waveSpeed = 0.4f;
                float wavePhase = time * waveSpeed;
                int waveColor = (int)(80.0f + 60.0f * breath) << 24 | darkGray;
                for (int i = 0; i < 91; ++i) {
                    float wave = (float)Math.sin((float)i / 8.0f + wavePhase);
                    float intensity = (wave * 0.5f + 0.5f) * 0.2f;
                    if (intensity < 0.05f) continue;
                    int c = (int)(intensity * 120.0f) << 24 | darkGray;
                    graphics.m_280509_(x + i, y, x + i + 1, y + 5, c);
                }
                float shimmerCycle = time * 0.02f % 1.0f;
                if (shimmerCycle > 0.98f) {
                    float shimmerPhase = time * 0.25f % 1.0f;
                    int shimmerWidth = 3;
                    int shimmerX = x + (int)(shimmerPhase * (float)(91 + shimmerWidth)) - shimmerWidth;
                    for (int i = 0; i < shimmerWidth; ++i) {
                        float shape = 1.0f - Math.abs(2.0f * (float)i / (float)shimmerWidth - 1.0f);
                        shape = (float)Math.pow(shape, 2.5);
                        int whiteAlpha = (int)(shape * 140.0f);
                        int shimmerColor = whiteAlpha << 24 | steelGray;
                        int px = shimmerX + i;
                        if (px < x || px >= x + 91) continue;
                        graphics.m_280509_(px, y, px + 1, y + 5, shimmerColor);
                    }
                }
                float pulse = (float)(Math.sin((double)(time * 0.15f) * Math.PI * 2.0) * 0.5 + 0.5);
                int pulseAlpha = (int)(pulse * 25.0f);
                int pulseColor = pulseAlpha << 24 | 0xFFFFFF;
                graphics.m_280509_(x, y, x + 91, y + 5, pulseColor);
                String text = "\u041f\u041e\u0414\u0410\u0412\u041b\u0415\u041d\u041e";
                int textWidth = mc.f_91062_.m_92895_(text);
                int textX = x + 45 - textWidth / 2;
                int textY = y - 10;
                int textBase = 120 + (int)(Math.sin(time * 0.08f) * 40.0);
                int textColor = textBase << 16 | textBase << 8 | textBase;
                graphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)text), textX, textY, textColor, false);
            } else {
                int filled = (int)(91.0f * percent);
                if (filled > 0) {
                    graphics.m_280218_(ICONS, x, y, 0, 69, filled, 5);
                }
                int purpleRGB = 12591359;
                if (percent < 0.999f) {
                    float minSpeed = 0.005f;
                    float maxSpeed = 0.02f;
                    float dynamicSpeed = Mth.m_14179_((float)percent, (float)minSpeed, (float)maxSpeed);
                    float breath = (float)(Math.sin((double)(time * dynamicSpeed) * Math.PI * 2.0) * 0.5 + 0.5);
                    int minAlpha = 70;
                    int maxAlpha = 140;
                    int alpha = (int)Mth.m_14179_((float)breath, (float)minAlpha, (float)maxAlpha);
                    int purpleColor = alpha << 24 | purpleRGB;
                    if (filled > 0) {
                        graphics.m_280509_(x, y, x + filled, y + 5, purpleColor);
                    }
                } else {
                    int alpha = 140;
                    int purpleColor = alpha << 24 | purpleRGB;
                    graphics.m_280509_(x, y, x + filled, y + 5, purpleColor);
                    float shimmerSpeed = 0.1f;
                    float phase = time * shimmerSpeed % 1.0f;
                    int shimmerWidth = Math.max(6, 32);
                    int shimmerX = x + (int)(phase * (float)(91 + shimmerWidth)) - shimmerWidth;
                    for (int i = 0; i < shimmerWidth; ++i) {
                        float pos = (float)i / (float)(shimmerWidth - 1);
                        float shape = 1.0f - Math.abs(2.0f * pos - 1.0f);
                        int whiteAlpha = (int)((shape = (float)Math.pow(shape, 1.5)) * 110.0f);
                        if (whiteAlpha <= 0) continue;
                        int whiteColor = whiteAlpha << 24 | 0xFFFFFF;
                        int px = shimmerX + i;
                        if (px < x || px >= x + 91) continue;
                        graphics.m_280509_(px, y, px + 1, y + 5, whiteColor);
                    }
                }
                String text = current + " / " + max;
                int textWidth = mc.f_91062_.m_92895_(text);
                int textX = x + 45 - textWidth / 2;
                graphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)text), textX, y - 10, 0xFFFFFF, false);
            }
        });
    };

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "vorial_bar", VORIAL_BAR);
    }
}

