/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.vorial;

import com.example.junctionmod.effect.ModMobEffects;
import com.example.junctionmod.event.GlobalEventManager;
import com.example.junctionmod.event.GlobalEventType;
import com.example.junctionmod.tertserskill.TertserSkill;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;

public class VorialCapability {
    public static Capability<VorialCapability> INSTANCE;
    private int vorial;
    private boolean isSuppressed = false;
    private int lastSyncedVorial = -1;
    private boolean lastSyncedSuppressed = false;

    public int getVorial() {
        return this.vorial;
    }

    public void consumeVorial(ServerPlayer player, int amount) {
        this.vorial = Math.max(0, this.vorial - amount);
    }

    public void setVorial(int vorial) {
        this.vorial = Math.max(0, vorial);
    }

    public void addVorial(Player player, int amount) {
        int max = VorialCapability.getMaxVorial(player);
        this.vorial = Math.min(this.vorial + amount, max);
    }

    public void removeVorial(int vorial) {
        this.vorial = Math.max(0, this.vorial - vorial);
    }

    public static int getMaxVorial(Player player) {
        AtomicInteger maxVorial = new AtomicInteger(200);
        player.getCapability(TertserSkill.INSTANCE).ifPresent(tertserCap -> {
            ServerPlayer serverPlayer;
            GlobalEventManager manager;
            int level = tertserCap.getCurrentLevel();
            int calculatedMax = TertserSkill.getMaxVorialForLevel(level);
            if (player instanceof ServerPlayer && (manager = GlobalEventManager.get((serverPlayer = (ServerPlayer)player).m_284548_())).isEventActive(GlobalEventType.VOID_CALL) && serverPlayer.m_9236_().m_46472_().m_135782_().toString().equals("theabyss:the_abyss")) {
                calculatedMax = 2000;
            }
            if (player.m_21023_((MobEffect)ModMobEffects.FRACTURED_SPARK.get())) {
                calculatedMax = (int)((float)calculatedMax * 0.7f);
            }
            maxVorial.set(calculatedMax);
        });
        return maxVorial.get();
    }

    public boolean isSuppressed() {
        return this.isSuppressed;
    }

    public void setSuppressed(boolean suppressed) {
        this.isSuppressed = suppressed;
    }

    public void copyFrom(VorialCapability other) {
        this.vorial = other.vorial;
        this.isSuppressed = other.isSuppressed;
    }

    public CompoundTag saveNBTData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("vorial", this.vorial);
        return nbt;
    }

    public void loadNBTData(CompoundTag nbt) {
        this.vorial = nbt.m_128451_("vorial");
    }

    public boolean needsSync() {
        return this.lastSyncedVorial != this.vorial || this.lastSyncedSuppressed != this.isSuppressed;
    }

    public void markSynced() {
        this.lastSyncedVorial = this.vorial;
        this.lastSyncedSuppressed = this.isSuppressed;
    }
}

