/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.thermo;

import com.example.junctionmod.ModRegistry;
import com.example.junctionmod.item.CrystallizedVorialItem;
import com.example.junctionmod.thermo.ThermoContainerBlock;
import com.example.junctionmod.thermo.ThermoContainerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThermoContainerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            ThermoContainerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 1) {
                return stack.m_41720_() == Items.f_42201_;
            }
            return true;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ThermoContainerBlockEntity.this.fuelTime;
                case 1 -> ThermoContainerBlockEntity.this.maxFuelTime;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ThermoContainerBlockEntity.this.fuelTime = value;
                    break;
                }
                case 1: {
                    ThermoContainerBlockEntity.this.maxFuelTime = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int fuelTime = 0;
    private int maxFuelTime = 1200;

    public ThermoContainerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.THERMO_CONTAINER_BE.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"\u0422\u0435\u0440\u043c\u043e-\u041a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ThermoContainerMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("fuelTime", this.fuelTime);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.fuelTime = nbt.m_128451_("fuelTime");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ThermoContainerBlockEntity pEntity) {
        if (level.f_46443_) {
            return;
        }
        boolean isCooling = pEntity.fuelTime > 0;
        boolean changed = false;
        if (isCooling) {
            --pEntity.fuelTime;
        }
        ItemStack inputStack = pEntity.itemHandler.getStackInSlot(0);
        ItemStack fuelStack = pEntity.itemHandler.getStackInSlot(1);
        if (pEntity.fuelTime <= 0 && !fuelStack.m_41619_() && !inputStack.m_41619_() && fuelStack.m_41720_() == Items.f_42201_) {
            fuelStack.m_41774_(1);
            pEntity.fuelTime = 1200;
            pEntity.maxFuelTime = 1200;
            changed = true;
            isCooling = true;
        }
        if (!inputStack.m_41619_() && !isCooling && inputStack.m_41720_() instanceof CrystallizedVorialItem) {
            CompoundTag tag = inputStack.m_41784_();
            int meltTimer = tag.m_128451_("MeltTimer");
            if (++meltTimer >= 6000) {
                pEntity.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
                level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                tag.m_128405_("MeltTimer", meltTimer);
            }
            if (meltTimer % 20 == 0) {
                changed = true;
                pEntity.itemHandler.setStackInSlot(0, inputStack);
            }
        }
        if ((Boolean)state.m_61143_((Property)ThermoContainerBlock.LIT) != isCooling) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ThermoContainerBlock.LIT, (Comparable)Boolean.valueOf(isCooling)), 3);
            changed = true;
        }
        if (changed) {
            pEntity.m_6596_();
        }
    }
}

