/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.tertserskill;

import com.example.junctionmod.client.ClientPayloadHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class TertserSkillSyncPacket {
    private final int currentLevel;
    private final int jumpsCount;
    private final int totalJumpsCount;
    private final int anomaliesCount;
    private final int ownedAnchors;
    private final List<GlobalPos> knownAnchors;
    private final List<String> knownAnchorNames;

    public TertserSkillSyncPacket(int currentLevel, int jumpsCount, int totalJumpsCount, int anomaliesCount, int ownedAnchors, List<GlobalPos> knownAnchors, List<String> knownAnchorNames) {
        this.currentLevel = currentLevel;
        this.jumpsCount = jumpsCount;
        this.totalJumpsCount = totalJumpsCount;
        this.anomaliesCount = anomaliesCount;
        this.ownedAnchors = ownedAnchors;
        this.knownAnchors = knownAnchors;
        this.knownAnchorNames = knownAnchorNames;
    }

    public TertserSkillSyncPacket(int currentLevel, int jumpsCount, int totalJumpsCount, int anomaliesCount, int ownedAnchors, List<GlobalPos> knownAnchors) {
        this(currentLevel, jumpsCount, totalJumpsCount, anomaliesCount, ownedAnchors, knownAnchors, new ArrayList<String>());
    }

    public TertserSkillSyncPacket(int currentLevel, int jumpsCount, int totalJumpsCount, int anomaliesCount) {
        this(currentLevel, jumpsCount, totalJumpsCount, anomaliesCount, 0, new ArrayList<GlobalPos>(), new ArrayList<String>());
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public int getJumpsCount() {
        return this.jumpsCount;
    }

    public int getTotalJumpsCount() {
        return this.totalJumpsCount;
    }

    public int getAnomaliesCount() {
        return this.anomaliesCount;
    }

    public int getOwnedAnchors() {
        return this.ownedAnchors;
    }

    public List<GlobalPos> getKnownAnchors() {
        return this.knownAnchors;
    }

    public List<String> getKnownAnchorNames() {
        return this.knownAnchorNames;
    }

    public static void encode(TertserSkillSyncPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.currentLevel);
        buf.writeInt(msg.jumpsCount);
        buf.writeInt(msg.totalJumpsCount);
        buf.writeInt(msg.anomaliesCount);
        buf.writeInt(msg.ownedAnchors);
        buf.writeInt(msg.knownAnchors.size());
        for (int i = 0; i < msg.knownAnchors.size(); ++i) {
            GlobalPos pos = msg.knownAnchors.get(i);
            String name = msg.knownAnchorNames != null && i < msg.knownAnchorNames.size() ? msg.knownAnchorNames.get(i) : "Unknown";
            buf.m_130085_(pos.m_122640_().m_135782_());
            buf.m_130064_(pos.m_122646_());
            buf.m_130070_(name);
        }
    }

    public static TertserSkillSyncPacket decode(FriendlyByteBuf buf) {
        int level = buf.readInt();
        int jumps = buf.readInt();
        int total = buf.readInt();
        int anoms = buf.readInt();
        int owned = buf.readInt();
        int size = buf.readInt();
        ArrayList<GlobalPos> anchors = new ArrayList<GlobalPos>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            anchors.add(GlobalPos.m_122643_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_()), (BlockPos)buf.m_130135_()));
            names.add(buf.m_130277_());
        }
        return new TertserSkillSyncPacket(level, jumps, total, anoms, owned, anchors, names);
    }

    public static void handle(TertserSkillSyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPayloadHandler.handleTertserSkillSync(msg)));
        ctx.get().setPacketHandled(true);
    }
}

