/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.tertserskill;

import com.example.junctionmod.tertserskill.ITertserSkill;
import com.example.junctionmod.tertserskill.TertserSkill;
import com.example.junctionmod.tertserskill.TertserSkillProvider;
import com.example.junctionmod.tertserskill.TertserSkillSyncPacket;
import com.example.junctionmod.vorial.VorialNetwork;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="junctionmod")
public class TertserSkillEvents {
    public static final ResourceLocation CAP_ID = new ResourceLocation("junctionmod", "tertserskill");

    @SubscribeEvent
    public static void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(ITertserSkill.class);
    }

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(TertserSkill.INSTANCE).isPresent()) {
            event.addCapability(CAP_ID, (ICapabilityProvider)new TertserSkillProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(TertserSkill.INSTANCE).ifPresent(oldCap -> event.getEntity().getCapability(TertserSkill.INSTANCE).ifPresent(newCap -> newCap.copyFrom((ITertserSkill)oldCap)));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            TertserSkillEvents.syncTertserSkill(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            TertserSkillEvents.syncTertserSkill(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            TertserSkillEvents.syncTertserSkill(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.player.m_9236_().f_46443_) {
            return;
        }
        if (event.player.f_19797_ % 10 != 0) {
            return;
        }
        event.player.getCapability(TertserSkill.INSTANCE).ifPresent(skill -> {
            if (skill.isMadnessActive()) {
                ServerLevel level = (ServerLevel)event.player.m_9236_();
                level.m_8767_((ParticleOptions)ParticleTypes.f_123799_, event.player.m_20185_(), event.player.m_20186_() + 1.0, event.player.m_20189_(), 3, 0.3, 0.5, 0.3, 0.02);
                if (event.player.f_19797_ % 40 == 0) {
                    level.m_5594_(null, event.player.m_20183_(), SoundEvents.f_276532_, SoundSource.PLAYERS, 0.5f, 0.5f);
                }
            }
        });
    }

    public static void syncTertserSkill(ServerPlayer player) {
        player.getCapability(TertserSkill.INSTANCE).ifPresent(skill -> {
            skill.initializeIfNeeded();
            VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new TertserSkillSyncPacket(skill.getCurrentLevel(), skill.getJumpsCount(), skill.getTotalJumpsCount(), skill.getAnomaliesCount(), skill.getOwnedAnchorsCount(), skill.getKnownAnchors()));
        });
    }
}

