/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.partikls;

import com.example.junctionmod.client.ClientPayloadHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class TeleportEffectPacket {
    private final int playerId;
    private final boolean startEffect;

    public TeleportEffectPacket(int playerId, boolean startEffect) {
        this.playerId = playerId;
        this.startEffect = startEffect;
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public boolean isStartEffect() {
        return this.startEffect;
    }

    public static void encode(TeleportEffectPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.playerId);
        buf.writeBoolean(pkt.startEffect);
    }

    public static TeleportEffectPacket decode(FriendlyByteBuf buf) {
        return new TeleportEffectPacket(buf.readInt(), buf.readBoolean());
    }

    public static void handle(TeleportEffectPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPayloadHandler.handleTeleportEffect(pkt)));
        ctx.get().setPacketHandled(true);
    }
}

