/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.monolith;

import com.example.junctionmod.client.ClientPayloadHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MonolithSyncPacket {
    private final BlockPos pos;
    private final List<String> whitelist;

    public MonolithSyncPacket(BlockPos pos, List<String> whitelist) {
        this.pos = pos;
        this.whitelist = whitelist;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public List<String> getWhitelist() {
        return this.whitelist;
    }

    public static void encode(MonolithSyncPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.whitelist.size());
        for (String name : msg.whitelist) {
            buf.m_130070_(name);
        }
    }

    public static MonolithSyncPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int size = buf.readInt();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            list.add(buf.m_130277_());
        }
        return new MonolithSyncPacket(pos, list);
    }

    public static void handle(MonolithSyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPayloadHandler.handleMonolithSync(msg)));
        ctx.get().setPacketHandled(true);
    }
}

