/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.monolith;

import com.example.junctionmod.monolith.MonolithBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MonolithActionPacket {
    private final BlockPos pos;
    private final Action action;
    private final String playerName;

    public MonolithActionPacket(BlockPos pos, Action action, String playerName) {
        this.pos = pos;
        this.action = action;
        this.playerName = playerName;
    }

    public static void encode(MonolithActionPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.m_130068_((Enum)msg.action);
        buf.m_130070_(msg.playerName);
    }

    public static MonolithActionPacket decode(FriendlyByteBuf buf) {
        return new MonolithActionPacket(buf.m_130135_(), (Action)buf.m_130066_(Action.class), buf.m_130277_());
    }

    public static void handle(MonolithActionPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity be;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            if (level.m_46749_(msg.pos) && (be = level.m_7702_(msg.pos)) instanceof MonolithBlockEntity) {
                MonolithBlockEntity monolith = (MonolithBlockEntity)be;
                if (monolith.isOwner((Player)player) || player.m_20310_(2)) {
                    if (msg.action == Action.ADD) {
                        monolith.addToWhitelist(msg.playerName);
                    } else {
                        monolith.removeFromWhitelist(msg.playerName);
                    }
                } else {
                    System.out.println("Player " + player.m_7755_().getString() + " tried to modify Monolith without permission.");
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Action {
        ADD,
        REMOVE;

    }
}

