/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.monolith;

import com.example.junctionmod.monolith.MonolithBlock;
import com.example.junctionmod.monolith.MonolithManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="junctionmod")
public class ExplosionRegenHandler {
    private static final List<RegenEntry> regenQueue = new ArrayList<RegenEntry>();

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        Iterator iterator = event.getAffectedBlocks().iterator();
        while (iterator.hasNext()) {
            BlockState state;
            BlockPos pos = (BlockPos)iterator.next();
            if (MonolithManager.getProtectingMonolith((Level)level, pos) == null || (state = level.m_8055_(pos)).m_60795_() || state.m_60734_() instanceof MonolithBlock) continue;
            regenQueue.add(new RegenEntry(level, pos, state, level.m_46467_() + 200L));
            iterator.remove();
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        long time = System.currentTimeMillis();
        Iterator<RegenEntry> iterator = regenQueue.iterator();
        while (iterator.hasNext()) {
            RegenEntry entry = iterator.next();
            if (entry.level.m_46467_() < entry.restoreTime) continue;
            entry.level.m_7731_(entry.pos, entry.state, 3);
            entry.level.m_46796_(2001, entry.pos, Block.m_49956_((BlockState)entry.state()));
            iterator.remove();
        }
    }

    private record RegenEntry(ServerLevel level, BlockPos pos, BlockState state, long restoreTime) {
    }
}

