/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.gui_vorial;

import com.example.junctionmod.anchor.AnchorActionPacket;
import com.example.junctionmod.anchor.AnchorRenamePacket;
import com.example.junctionmod.anchor.SpatialAnchorBlockEntity;
import com.example.junctionmod.anchor.SpatialAnchorMenu;
import com.example.junctionmod.vorial.VorialNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SpatialAnchorScreen
extends AbstractContainerScreen<SpatialAnchorMenu> {
    private EditBox nameBox;
    private final List<PlayerListEntry> displayedPlayers = new ArrayList<PlayerListEntry>();
    private int panelWidth = 260;
    private int panelHeight = 200;
    private static final int COLOR_BG = -587202560;
    private static final int COLOR_BORDER_OUTER = -12303292;
    private static final int COLOR_BORDER_INNER = -14540254;
    private static final int COLOR_GOLD = -10496;
    private static final int COLOR_TEXT_DIM = -5592406;
    private static final int COLOR_GREEN = -11141291;
    private static final int COLOR_RED = -43691;

    public SpatialAnchorScreen(SpatialAnchorMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = this.panelWidth;
        this.f_97727_ = this.panelHeight;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        SpatialAnchorBlockEntity be = ((SpatialAnchorMenu)this.f_97732_).getBlockEntity();
        int boxW = 180;
        this.nameBox = new EditBox(this.f_96547_, x + (this.panelWidth - boxW) / 2, y + 45, boxW, 12, (Component)Component.m_237113_((String)"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"));
        this.nameBox.m_94199_(32);
        this.nameBox.m_94144_(be.getAnchorName());
        this.nameBox.m_94182_(false);
        this.nameBox.m_94202_(-1);
        this.m_142416_((GuiEventListener)this.nameBox);
        this.updatePlayerList();
    }

    private void updatePlayerList() {
        this.displayedPlayers.clear();
        SpatialAnchorBlockEntity be = ((SpatialAnchorMenu)this.f_97732_).getBlockEntity();
        Map<UUID, String> users = be.getKnownUsers();
        int index = 0;
        for (Map.Entry<UUID, String> entry : users.entrySet()) {
            if (index >= 6) break;
            this.displayedPlayers.add(new PlayerListEntry(entry.getKey(), entry.getValue(), be.isBanned(entry.getKey())));
            ++index;
        }
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(gfx);
        this.drawStyledWindow(gfx);
        this.drawContent(gfx, mouseX, mouseY);
        super.m_88315_(gfx, mouseX, mouseY, partialTick);
        this.m_280072_(gfx, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics gfx, float partialTick, int mouseX, int mouseY) {
    }

    protected void m_280003_(GuiGraphics gfx, int mouseX, int mouseY) {
    }

    private void drawStyledWindow(GuiGraphics gfx) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        gfx.m_280509_(x, y, x + this.f_97726_, y + this.f_97727_, -587202560);
        gfx.m_280637_(x - 1, y - 1, this.f_97726_ + 2, this.f_97727_ + 2, -12303292);
        gfx.m_280637_(x + 4, y + 4, this.f_97726_ - 8, this.f_97727_ - 8, -14540254);
        gfx.m_280168_().m_85836_();
        gfx.m_280168_().m_85837_((double)x + (double)this.f_97726_ / 2.0, (double)(y + 15), 0.0);
        gfx.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
        gfx.m_280137_(this.f_96547_, "\u0423\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u0418\u0415 \u042f\u041a\u041e\u0420\u0415\u041c", 0, 0, -10496);
        gfx.m_280168_().m_85849_();
    }

    private void drawContent(GuiGraphics gfx, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        SpatialAnchorBlockEntity be = ((SpatialAnchorMenu)this.f_97732_).getBlockEntity();
        int boxX = x + (this.panelWidth - 180) / 2;
        int boxY = y + 45;
        gfx.m_280509_(boxX, boxY + 12, boxX + 180, boxY + 13, -10496);
        boolean hoverSave = this.isMouseOver(mouseX, mouseY, boxX + 185, boxY, 30, 12);
        int saveColor = hoverSave ? -1 : -5592406;
        gfx.m_280056_(this.f_96547_, "[\u0421\u043e\u0445\u0440.]", boxX + 185, boxY + 2, saveColor, false);
        boolean isActive = be.isActive();
        String statusText = isActive ? "\u0421\u0422\u0410\u0422\u0423\u0421: \u0410\u041a\u0422\u0418\u0412\u0415\u041d" : "\u0421\u0422\u0410\u0422\u0423\u0421: \u0421\u041a\u0420\u042b\u0422";
        int statusColor = isActive ? -11141291 : -43691;
        int statusY = y + 70;
        int statusW = this.f_96547_.m_92895_(statusText) + 20;
        int statusX = x + (this.panelWidth - statusW) / 2;
        boolean hoverStatus = this.isMouseOver(mouseX, mouseY, statusX, statusY, statusW, 14);
        int btnBg = hoverStatus ? 0x44FFFFFF : 0x22FFFFFF;
        gfx.m_280509_(statusX, statusY - 2, statusX + statusW, statusY + 12, btnBg);
        gfx.m_280637_(statusX, statusY - 2, statusW, 14, statusColor);
        gfx.m_280137_(this.f_96547_, statusText, x + this.panelWidth / 2, statusY + 1, statusColor);
        gfx.m_280137_(this.f_96547_, "- \u0420\u0435\u0437\u043e\u043d\u0438\u0440\u0443\u044e\u0449\u0438\u0435 \u0414\u0443\u0448\u0438 -", x + this.panelWidth / 2, y + 95, -5592406);
        this.updatePlayerList();
        int listStartY = y + 110;
        int rowHeight = 14;
        if (this.displayedPlayers.isEmpty()) {
            gfx.m_280137_(this.f_96547_, "\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u0443\u0441\u0442...", x + this.panelWidth / 2, listStartY + 20, -11184811);
        } else {
            for (int i = 0; i < this.displayedPlayers.size(); ++i) {
                PlayerListEntry entry = this.displayedPlayers.get(i);
                int rowX = x + 20;
                int rowY = listStartY + i * rowHeight;
                int rowW = this.panelWidth - 40;
                boolean isRowHovered = this.isMouseOver(mouseX, mouseY, rowX, rowY, rowW, rowHeight);
                if (isRowHovered) {
                    gfx.m_280509_(rowX, rowY, rowX + rowW, rowY + rowHeight, 0x22FFFFFF);
                }
                gfx.m_280056_(this.f_96547_, entry.name, rowX + 5, rowY + 3, -1, false);
                String permText = entry.isBanned ? "[\u0417\u0410\u0411\u041b\u041e\u041a\u0418\u0420\u041e\u0412\u0410\u041d]" : "[\u0414\u041e\u0421\u0422\u0423\u041f\u0415\u041d]";
                int permColor = entry.isBanned ? -43691 : -11141291;
                int permW = this.f_96547_.m_92895_(permText);
                gfx.m_280056_(this.f_96547_, permText, rowX + rowW - permW - 5, rowY + 3, permColor, false);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int statusY;
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            SpatialAnchorBlockEntity be = ((SpatialAnchorMenu)this.f_97732_).getBlockEntity();
            int boxX = x + (this.panelWidth - 180) / 2;
            int boxY = y + 45;
            if (this.isMouseOver(mouseX, mouseY, boxX + 185, boxY, 30, 12)) {
                String newName = this.nameBox.m_94155_();
                if (!newName.isEmpty()) {
                    VorialNetwork.CHANNEL.sendToServer((Object)new AnchorRenamePacket(be.m_58899_(), newName));
                    this.playClickSound();
                }
                return true;
            }
            boolean isActive = be.isActive();
            String statusText = isActive ? "\u0421\u0422\u0410\u0422\u0423\u0421: \u0410\u041a\u0422\u0418\u0412\u0415\u041d" : "\u0421\u0422\u0410\u0422\u0423\u0421: \u0421\u041a\u0420\u042b\u0422";
            int statusW = this.f_96547_.m_92895_(statusText) + 20;
            int statusX = x + (this.panelWidth - statusW) / 2;
            if (this.isMouseOver(mouseX, mouseY, statusX, (statusY = y + 70) - 2, statusW, 14)) {
                this.sendAction(AnchorActionPacket.Action.TOGGLE_ACTIVE, null);
                be.setActive(!be.isActive());
                this.playClickSound();
                return true;
            }
            int listStartY = y + 110;
            int rowHeight = 14;
            int rowX = x + 20;
            int rowW = this.panelWidth - 40;
            for (int i = 0; i < this.displayedPlayers.size(); ++i) {
                int rowY = listStartY + i * rowHeight;
                if (!this.isMouseOver(mouseX, mouseY, rowX, rowY, rowW, rowHeight)) continue;
                PlayerListEntry entry = this.displayedPlayers.get(i);
                this.sendAction(AnchorActionPacket.Action.TOGGLE_BAN, entry.uuid);
                be.toggleBan(entry.uuid);
                this.playClickSound();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if ((keyCode == 257 || keyCode == 335) && this.nameBox.m_93696_()) {
            String newName = this.nameBox.m_94155_();
            if (!newName.isEmpty()) {
                VorialNetwork.CHANNEL.sendToServer((Object)new AnchorRenamePacket(((SpatialAnchorMenu)this.f_97732_).getBlockEntity().m_58899_(), newName));
                this.playClickSound();
                this.nameBox.m_93692_(false);
            }
            return true;
        }
        if (this.nameBox.m_7933_(keyCode, scanCode, modifiers) || this.nameBox.m_94204_()) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private boolean isMouseOver(double mouseX, double mouseY, int x, int y, int w, int h) {
        return mouseX >= (double)x && mouseX < (double)(x + w) && mouseY >= (double)y && mouseY < (double)(y + h);
    }

    private void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    private void sendAction(AnchorActionPacket.Action action, UUID target) {
        VorialNetwork.CHANNEL.sendToServer((Object)new AnchorActionPacket(((SpatialAnchorMenu)this.f_97732_).getBlockEntity().m_58899_(), action, target));
    }

    private record PlayerListEntry(UUID uuid, String name, boolean isBanned) {
    }
}

