/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.gui_vorial;

import com.example.junctionmod.monolith.MonolithActionPacket;
import com.example.junctionmod.monolith.MonolithMenu;
import com.example.junctionmod.vorial.VorialNetwork;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class MonolithScreen
extends AbstractContainerScreen<MonolithMenu> {
    private EditBox nameInput;
    private Button addButton;
    private int currentTab = 0;
    private float scrollOffset = 0.0f;
    private static final int ROW_HEIGHT = 14;
    private static final int LIST_HEIGHT = 75;
    private static final int COLOR_BG = -300871407;
    private static final int COLOR_BG_OPAQUE = -15658735;
    private static final int COLOR_BORDER = -12303292;
    private static final int COLOR_ACCENT = -6749953;
    private static final int COLOR_TEXT = -2039584;
    private static final int COLOR_INACTIVE = -11184811;

    public MonolithScreen(MonolithMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 240;
        this.f_97727_ = 186;
        this.f_97731_ = 1000;
        this.f_97729_ = 1000;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.nameInput = new EditBox(this.f_96547_, x + 130, y + 40, 80, 16, (Component)Component.m_237113_((String)"\u041d\u0438\u043a\u043d\u0435\u0439\u043c"));
        this.nameInput.m_94199_(16);
        this.nameInput.m_94182_(true);
        this.nameInput.m_94202_(0xFFFFFF);
        this.nameInput.m_94194_(false);
        this.m_142416_((GuiEventListener)this.nameInput);
        this.addButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+"), btn -> this.addPlayer()).m_252987_(x + 215, y + 38, 20, 20).m_253136_());
        this.addButton.f_93624_ = false;
        this.updateVisibility();
    }

    private void updateVisibility() {
        boolean isSecurityTab;
        boolean bl = isSecurityTab = this.currentTab == 1;
        if (this.nameInput != null) {
            this.nameInput.m_94194_(isSecurityTab);
        }
        if (this.addButton != null) {
            this.addButton.f_93624_ = isSecurityTab;
        }
    }

    private boolean isOwner() {
        return ((MonolithMenu)this.f_97732_).blockEntity.isOwner((Player)Minecraft.m_91087_().f_91074_);
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(gfx);
        super.m_88315_(gfx, mouseX, mouseY, partialTick);
        if (this.currentTab == 1) {
            gfx.m_280168_().m_85836_();
            gfx.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            int slotX = x + 80;
            int slotY = y + 35;
            gfx.m_280509_(slotX - 2, slotY - 2, slotX + 18, slotY + 18, -15658735);
            gfx.m_280637_(slotX - 2, slotY - 2, 20, 20, -15658735);
            gfx.m_280137_(this.f_96547_, "\ud83d\udd12", slotX + 8, slotY + 4, -11184811);
            this.renderScrollableList(gfx, x, y, mouseX, mouseY);
            gfx.m_280168_().m_85849_();
        }
        this.m_280072_(gfx, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics gfx, float partialTick, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.drawTab(gfx, x + 10, y - 18, "\u0421\u0422\u0410\u0422\u0423\u0421", 0, mouseX, mouseY);
        this.drawTab(gfx, x + 70, y - 18, "\u0414\u041e\u0421\u0422\u0423\u041f", 1, mouseX, mouseY);
        gfx.m_280509_(x, y, x + this.f_97726_, y + this.f_97727_, -300871407);
        gfx.m_280637_(x, y, this.f_97726_, this.f_97727_, -12303292);
        if (this.currentTab == 0) {
            this.renderInfoTab(gfx, x, y);
        } else {
            gfx.m_280056_(this.f_96547_, "\u0423\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u0418\u0415 \u0414\u041e\u0421\u0422\u0423\u041f\u041e\u041c", x + 10, y + 10, -2039584, false);
        }
        this.drawPlayerInventorySlots(gfx, x, y);
    }

    private void renderScrollableList(GuiGraphics gfx, int x, int y, int mouseX, int mouseY) {
        ArrayList<String> whitelist = new ArrayList<String>(((MonolithMenu)this.f_97732_).blockEntity.getWhitelist());
        int listX = x + 15;
        int listY = y + 65;
        int listW = 210;
        int listH = 75;
        gfx.m_280509_(listX, listY, listX + listW, listY + listH, -16250872);
        gfx.m_280637_(listX, listY, listW, listH, -13421773);
        if (whitelist.isEmpty()) {
            gfx.m_280137_(this.f_96547_, "\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u0443\u0441\u0442 (\u0434\u043e\u0441\u0442\u0443\u043f \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u0430\u043c)", listX + listW / 2, listY + listH / 2 - 4, -8947849);
            return;
        }
        int contentHeight = whitelist.size() * 14;
        gfx.m_280588_(listX + 1, listY + 1, listX + listW - 1, listY + listH - 1);
        int startY = (int)((float)(listY + 2) - this.scrollOffset);
        for (int i = 0; i < whitelist.size(); ++i) {
            boolean insideList;
            String name = (String)whitelist.get(i);
            int rowY = startY + i * 14;
            gfx.m_280056_(this.f_96547_, "\u2022 " + name, listX + 5, rowY + 3, -1, false);
            int btnX = listX + listW - 20;
            boolean hover = mouseX >= btnX && mouseX <= btnX + 10 && mouseY >= rowY && mouseY <= rowY + 10;
            boolean bl = insideList = mouseY >= listY && mouseY <= listY + listH;
            if (hover && insideList) {
                gfx.m_280056_(this.f_96547_, "[x]", btnX, rowY + 3, -43691, false);
                continue;
            }
            gfx.m_280056_(this.f_96547_, "[x]", btnX, rowY + 3, -5636096, false);
        }
        gfx.m_280618_();
        if (contentHeight > listH) {
            int barX = listX + listW - 4;
            int barH = (int)((float)listH / (float)contentHeight * (float)listH);
            if (barH < 10) {
                barH = 10;
            }
            int maxScroll = contentHeight - listH;
            int barY = listY + (int)(this.scrollOffset / (float)maxScroll * (float)(listH - barH));
            gfx.m_280509_(barX, listY, barX + 2, listY + listH, -14540254);
            gfx.m_280509_(barX, barY, barX + 2, barY + barH, -6749953);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        ArrayList<String> whitelist;
        int contentHeight;
        if (this.currentTab == 1 && (contentHeight = (whitelist = new ArrayList<String>(((MonolithMenu)this.f_97732_).blockEntity.getWhitelist())).size() * 14) > 75) {
            int maxScroll = contentHeight - 75;
            this.scrollOffset = (float)((double)this.scrollOffset - delta * 14.0);
            if (this.scrollOffset < 0.0f) {
                this.scrollOffset = 0.0f;
            }
            if (this.scrollOffset > (float)maxScroll) {
                this.scrollOffset = maxScroll;
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (mouseY >= (double)(y - 18) && mouseY <= (double)y) {
            if (mouseX >= (double)(x + 10) && mouseX <= (double)(x + 65)) {
                this.currentTab = 0;
                this.updateVisibility();
                this.playClickSound();
                return true;
            }
            if (mouseX >= (double)(x + 70) && mouseX <= (double)(x + 125)) {
                if (this.isOwner()) {
                    this.currentTab = 1;
                    this.updateVisibility();
                    this.playClickSound();
                } else {
                    Minecraft.m_91087_().f_91073_.m_245747_(Minecraft.m_91087_().f_91074_.m_20183_(), (SoundEvent)SoundEvents.f_12209_.m_203334_(), SoundSource.MASTER, 1.0f, 0.5f, false);
                }
                return true;
            }
        }
        if (this.currentTab == 1 && this.isOwner()) {
            int btnX;
            double relativeY;
            int index;
            ArrayList<String> whitelist = new ArrayList<String>(((MonolithMenu)this.f_97732_).blockEntity.getWhitelist());
            int listX = x + 15;
            int listY = y + 65;
            int listW = 210;
            int listH = 75;
            if (mouseX >= (double)listX && mouseX <= (double)(listX + listW) && mouseY >= (double)listY && mouseY <= (double)(listY + listH) && (index = (int)((relativeY = mouseY - (double)listY + (double)this.scrollOffset) / 14.0)) >= 0 && index < whitelist.size() && mouseX >= (double)(btnX = listX + listW - 20) && mouseX <= (double)(btnX + 15)) {
                this.removePlayer((String)whitelist.get(index));
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void drawTab(GuiGraphics gfx, int x, int y, String title, int tabIndex, int mx, int my) {
        int colorText;
        boolean isActive = this.currentTab == tabIndex;
        boolean isLocked = tabIndex == 1 && !this.isOwner();
        int w = 55;
        int h = 18;
        int colorBg = isActive ? -300871407 : -14540254;
        int colorBorder = isActive ? -6749953 : -12303292;
        int n = colorText = isActive ? -6749953 : -2039584;
        if (isLocked) {
            colorText = -11184811;
            colorBg = -15658735;
        } else if (mx >= x && mx <= x + w && my >= y && my <= y + h) {
            colorBg = -13421773;
        }
        gfx.m_280509_(x, y, x + w, y + h + 2, colorBg);
        gfx.m_280637_(x, y, w, h + 2, colorBorder);
        if (isActive) {
            gfx.m_280509_(x + 1, y + h, x + w - 1, y + h + 2, colorBg);
        }
        if (isLocked) {
            gfx.m_280056_(this.f_96547_, "\ud83d\udd12", x + w / 2 - 4, y + 5, colorText, false);
        } else {
            gfx.m_280137_(this.f_96547_, title, x + w / 2, y + 5, colorText);
        }
    }

    private void renderInfoTab(GuiGraphics gfx, int x, int y) {
        gfx.m_280056_(this.f_96547_, "\u0422\u0415\u0425\u041d\u0418\u0427\u0415\u0421\u041a\u0418\u0419 \u041e\u0422\u0421\u0415\u041a", x + 10, y + 10, -2039584, false);
        int fuelTicks = ((MonolithMenu)this.f_97732_).getFuelTicks();
        ItemStack fuelStack = ((MonolithMenu)this.f_97732_).m_38853_(0).m_7993_();
        int stackCount = fuelStack.m_41619_() ? 0 : fuelStack.m_41613_();
        long ticksInStack = (long)stackCount * 72000L;
        long totalTicks = (long)fuelTicks + ticksInStack;
        String timeNow = this.formatTime(fuelTicks);
        String timeTotal = this.formatTime(totalTicks);
        int slotX = x + 80;
        int slotY = y + 35;
        gfx.m_280509_(slotX - 1, slotY - 1, slotX + 17, slotY + 17, -16777216);
        gfx.m_280637_(slotX - 1, slotY - 1, 18, 18, -6749953);
        if (fuelStack.m_41619_() && fuelTicks == 0) {
            gfx.m_280056_(this.f_96547_, "\u26a0 \u041d\u0415\u0422 \u0422\u041e\u041f\u041b\u0418\u0412\u0410", x + 105, y + 39, -43691, false);
        }
        gfx.m_280056_(this.f_96547_, "\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0437\u0430\u0440\u044f\u0434: ", x + 20, y + 65, -5592406, false);
        gfx.m_280056_(this.f_96547_, timeNow, x + 120, y + 65, -6749953, false);
        gfx.m_280056_(this.f_96547_, "\u041f\u043e\u043b\u043d\u044b\u0439 \u0437\u0430\u043f\u0430\u0441: ", x + 20, y + 75, -5592406, false);
        gfx.m_280056_(this.f_96547_, timeTotal, x + 120, y + 75, -11141291, false);
        gfx.m_280137_(this.f_96547_, "(1 \u041f\u044b\u043b\u044c = 1 \u0427\u0430\u0441 \u0440\u0430\u0431\u043e\u0442\u044b)", x + this.f_97726_ / 2, y + 90, -8947849);
        int fuelH = ((MonolithMenu)this.f_97732_).getFuelProgress();
        if (fuelH > 0) {
            int barX = slotX - 5;
            int barY = slotY + 16;
            gfx.m_280509_(barX, slotY + 2, barX + 3, slotY + 16, -14548958);
            gfx.m_280509_(barX, barY - fuelH, barX + 3, barY, -6749953);
        }
    }

    private void drawPlayerInventorySlots(GuiGraphics gfx, int x, int y) {
        int startY = y + 99;
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.drawSlotBg(gfx, x + 7 + l * 18, startY + i * 18);
            }
        }
        int hotbarY = y + 157;
        for (int i = 0; i < 9; ++i) {
            this.drawSlotBg(gfx, x + 7 + i * 18, hotbarY);
        }
    }

    private void drawSlotBg(GuiGraphics gfx, int x, int y) {
        gfx.m_280509_(x, y, x + 18, y + 18, -14540254);
        gfx.m_280637_(x, y, 18, 18, -11184811);
    }

    private String formatTime(long ticks) {
        if (ticks <= 0L) {
            return "0\u043c";
        }
        long seconds = ticks / 20L;
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        if (hours > 0L) {
            return hours + "\u0447 " + minutes + "\u043c";
        }
        return minutes + "\u043c " + seconds % 60L + "\u0441";
    }

    private void addPlayer() {
        String name = this.nameInput.m_94155_().trim();
        if (!name.isEmpty()) {
            VorialNetwork.CHANNEL.sendToServer((Object)new MonolithActionPacket(((MonolithMenu)this.f_97732_).blockEntity.m_58899_(), MonolithActionPacket.Action.ADD, name));
            this.nameInput.m_94144_("");
            this.playClickSound();
        }
    }

    private void removePlayer(String name) {
        VorialNetwork.CHANNEL.sendToServer((Object)new MonolithActionPacket(((MonolithMenu)this.f_97732_).blockEntity.m_58899_(), MonolithActionPacket.Action.REMOVE, name));
        this.playClickSound();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.currentTab == 1 && this.nameInput.m_94213_()) {
            if ((keyCode == 257 || keyCode == 335) && this.nameInput.m_93696_()) {
                this.addPlayer();
                return true;
            }
            if (this.nameInput.m_7933_(keyCode, scanCode, modifiers) || this.nameInput.m_94204_()) {
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }
}

