/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.event;

import com.example.junctionmod.Atercenite.AterceniteManager;
import com.example.junctionmod.ModRegistry;
import com.example.junctionmod.effect.ModMobEffects;
import com.example.junctionmod.event.GlobalEventManager;
import com.example.junctionmod.event.GlobalEventType;
import com.example.junctionmod.vorial.VorialCapability;
import com.example.junctionmod.vorial.VorialNetwork;
import com.example.junctionmod.vorial.VorialSyncPacket;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="junctionmod")
public class JunctionEvents {
    private static final Random random = new Random();
    private static final ResourceKey<Level> HELHEIM_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("junctionworlds", "helheim"));
    private static final ResourceKey<Level> AMENTI_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("junctionworlds", "amenti"));

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        if (player.f_19797_ % 20 == 0) {
            JunctionEvents.handleGreatFrostMechanics(player);
            JunctionEvents.handleSunScorchMechanics(player);
        }
    }

    private static void handleGreatFrostMechanics(ServerPlayer player) {
        GlobalEventManager manager = GlobalEventManager.get(player.m_284548_());
        if (manager.isEventActive(GlobalEventType.GREAT_FROST) && player.m_9236_().m_46472_().equals(HELHEIM_KEY) && random.nextFloat() < 0.05f) {
            JunctionEvents.spawnFallingCrystal(player.m_284548_(), player);
        }
    }

    private static void handleSunScorchMechanics(ServerPlayer player) {
        GlobalEventManager manager = GlobalEventManager.get(player.m_284548_());
        if (manager.isEventActive(GlobalEventType.SOLAR_FLARE) && player.m_9236_().m_46472_().equals(AMENTI_KEY)) {
            boolean isDay;
            long time = player.m_9236_().m_46468_() % 24000L;
            boolean bl = isDay = time >= 0L && time < 13000L;
            if (isDay && !player.m_20071_()) {
                BlockPos pos = player.m_20183_().m_7494_();
                if (player.m_9236_().m_45527_(pos) && !AterceniteManager.isPlayerInField(player)) {
                    player.m_20254_(3);
                    player.m_6469_(player.m_9236_().m_269111_().m_269387_(), 2.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDimensionTravel(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.m_19880_().contains("SKILL_TRAVEL")) {
            return;
        }
        ServerLevel currentLevel = (ServerLevel)player.m_9236_();
        ResourceKey toDim = event.getDimension();
        ResourceKey fromDim = currentLevel.m_46472_();
        GlobalEventManager manager = GlobalEventManager.get(player.m_284548_());
        if (manager.isEventActive(GlobalEventType.GREAT_FROST)) {
            if (toDim.equals(HELHEIM_KEY)) {
                event.setCanceled(true);
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7b\u2744 \u0412\u0435\u043b\u0438\u043a\u0438\u0439 \u041c\u043e\u0440\u043e\u0437 \u0441\u043a\u043e\u0432\u0430\u043b \u043f\u0443\u0442\u0438 \u0432 \u0425\u0435\u0439\u043b\u0445\u0435\u0439\u043c! \u041f\u0440\u043e\u0445\u043e\u0434 \u0437\u0430\u043a\u0440\u044b\u0442."), true);
                return;
            }
            if (fromDim.equals(HELHEIM_KEY)) {
                AtomicBoolean canTravel = new AtomicBoolean(false);
                player.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                    if (cap.getVorial() >= 300) {
                        cap.consumeVorial(player, 300);
                        VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new VorialSyncPacket(cap.getVorial(), cap.isSuppressed()));
                        canTravel.set(true);
                    }
                });
                if (canTravel.get()) {
                    player.m_7292_(new MobEffectInstance((MobEffect)ModRegistry.CRYO_SHOCK_EFFECT.get(), 2400, 0));
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7b\u2744 \u0412\u044b \u043f\u0440\u043e\u0440\u0432\u0430\u043b\u0438\u0441\u044c \u0441\u043a\u0432\u043e\u0437\u044c \u0431\u0443\u0440\u044e \u0447\u0435\u0440\u0435\u0437 \u043f\u043e\u0440\u0442\u0430\u043b... (-300 \u0412\u043e\u0440\u0438\u0430\u043b\u044c)"), false);
                } else {
                    event.setCanceled(true);
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u2744 \u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u044d\u043d\u0435\u0440\u0433\u0438\u0438 \u0434\u043b\u044f \u043f\u0440\u043e\u0440\u044b\u0432\u0430 \u0431\u0443\u0440\u0438 \u0447\u0435\u0440\u0435\u0437 \u043f\u043e\u0440\u0442\u0430\u043b! \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f 300 \u0412\u043e\u0440\u0438\u0430\u043b\u044f."), true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRegen(LivingHealEvent event) {
        ServerPlayer player;
        GlobalEventManager manager;
        if (event.getEntity().m_21023_((MobEffect)ModRegistry.CRYO_SHOCK_EFFECT.get())) {
            event.setCanceled(true);
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (manager = GlobalEventManager.get((player = (ServerPlayer)livingEntity).m_284548_())).isEventActive(GlobalEventType.GREAT_FROST) && player.m_9236_().m_46472_().equals(HELHEIM_KEY) && event.getAmount() <= 1.0f && player.m_36324_().m_38702_() >= 18) {
            event.setCanceled(true);
        }
    }

    public static float getVorialRegenMultiplier(ServerPlayer player) {
        GlobalEventManager manager = GlobalEventManager.get(player.m_284548_());
        String dimId = player.m_9236_().m_46472_().m_135782_().toString();
        if (manager.isEventActive(GlobalEventType.GREAT_FROST)) {
            if (dimId.equals("junctionworlds:helheim") || dimId.equals("junctionmod:helheim")) {
                return 0.0f;
            }
            return 0.5f;
        }
        if (manager.isEventActive(GlobalEventType.VOID_CALL) && dimId.equals("theabyss:the_abyss")) {
            return 0.9f;
        }
        return 1.0f;
    }

    private static void spawnFallingCrystal(ServerLevel level, ServerPlayer player) {
        int offsetX = random.nextInt(32) - 16;
        int offsetZ = random.nextInt(32) - 16;
        int x = (int)player.m_20185_() + offsetX;
        int z = (int)player.m_20189_() + offsetZ;
        int ySurface = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        BlockPos spawnPos = new BlockPos(x, Math.min(ySurface + 10, level.m_151558_()), z);
        ItemStack stack = new ItemStack((ItemLike)ModRegistry.CRYSTALLIZED_VORIAL_ITEM.get());
        stack.m_41784_().m_128405_("MeltTimer", 0);
        ItemEntity itemEntity = new ItemEntity((Level)level, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, stack);
        itemEntity.m_20334_(random.nextGaussian() * 0.05, -0.2, random.nextGaussian() * 0.05);
        level.m_7967_((Entity)itemEntity);
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_21023_((MobEffect)ModMobEffects.FRACTURED_SPARK.get())) {
            float originalDamage = event.getAmount();
            event.setAmount(originalDamage * 1.1f);
        }
    }
}

