/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.entity;

import com.example.junctionmod.Atercenite.AterceniteManager;
import com.example.junctionmod.ModRegistry;
import com.example.junctionmod.capability.chunk.ChunkStability;
import com.example.junctionmod.capability.chunk.ChunkStabilityHandler;
import com.example.junctionmod.gui_vorial.TeleportRequestPacket;
import com.example.junctionmod.vorial.VorialCapability;
import com.example.junctionmod.vorial.VorialNetwork;
import com.example.junctionmod.vorial.VorialSyncPacket;
import com.example.junctionmod.world.IntersticeHandler;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Vector3f;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"junctionmod");
    public static final RegistryObject<EntityType<RiftEntity>> RIFT = ENTITY_TYPES.register("rift", () -> EntityType.Builder.m_20704_(RiftEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.5f, 3.0f).m_20702_(64).m_20717_(2).m_20712_(new ResourceLocation("junctionmod", "rift").toString()));

    public static void register(IEventBus eventBus) {
        ENTITY_TYPES.register(eventBus);
    }

    public static class RiftEntity
    extends Entity {
        public static final int RIFT_STATE_NORMAL = 0;
        public static final int RIFT_STATE_STITCHING = 1;
        public static final int VORIAL_DRAIN_PER_TICK = 1;
        public static final int STITCH_POINTS_COUNT = 4;
        private static final EntityDataAccessor<String> TARGET_DIM = SynchedEntityData.m_135353_(RiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        private static final EntityDataAccessor<Integer> CREATOR_LEVEL = SynchedEntityData.m_135353_(RiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        private static final EntityDataAccessor<Integer> TIER = SynchedEntityData.m_135353_(RiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        private static final EntityDataAccessor<Integer> STABILIZATION = SynchedEntityData.m_135353_(RiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(RiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        private static final EntityDataAccessor<Integer> STITCH_INDEX = SynchedEntityData.m_135353_(RiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        private static final EntityDataAccessor<Optional<UUID>> PLAYER_ID = SynchedEntityData.m_135353_(RiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        private static final EntityDataAccessor<CompoundTag> STITCH_POINTS_DATA = SynchedEntityData.m_135353_(RiftEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
        private int age = 0;
        private int maxAge = 2400;
        private final Random visualRandom = new Random();
        private static final Vector3f COLOR_WHITE = new Vector3f(1.0f, 1.0f, 1.0f);
        private static final Vector3f COLOR_PURPLE = new Vector3f(0.5f, 0.0f, 0.9f);
        private static final Vector3f COLOR_TOXIC_GREEN = new Vector3f(0.2f, 0.9f, 0.2f);
        private static final Vector3f COLOR_BLACK = new Vector3f(0.05f, 0.05f, 0.05f);
        private static final Vector3f COLOR_OBSIDIAN = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final Vector3f COLOR_VEIN_BLUE = new Vector3f(0.1f, 0.1f, 0.8f);
        private static final Vector3f COLOR_VEIN_PURPLE = new Vector3f(0.4f, 0.0f, 0.8f);

        public RiftEntity(EntityType<?> type, Level level) {
            super(type, level);
            this.f_19811_ = true;
        }

        public RiftEntity(Level level, double x, double y, double z, String targetDim, int creatorLvl, int tier, int secondsOverride) {
            this((EntityType)RIFT.get(), level);
            this.m_6034_(x, y, z);
            this.setCreatorLevel(creatorLvl);
            this.setTargetDimension(targetDim);
            this.setTier(tier);
            this.setStabilization(0);
            this.setRiftState(0);
            this.setStitchIndex(0);
            if (secondsOverride > 0) {
                this.maxAge = secondsOverride * 20;
            } else {
                this.calculateDefaultLifespan(tier, creatorLvl);
            }
        }

        public RiftEntity(Level level, double x, double y, double z, String targetDim, int creatorLvl, int tier) {
            this(level, x, y, z, targetDim, creatorLvl, tier, -1);
        }

        private void calculateDefaultLifespan(int tier, int creatorLvl) {
            Random r = new Random();
            switch (tier) {
                case 1: {
                    int secondsT1 = 600 + r.nextInt(900);
                    this.maxAge = secondsT1 * 20;
                    break;
                }
                case 2: {
                    int baseMinutes = 2 + r.nextInt(4);
                    int totalMinutes = baseMinutes + creatorLvl;
                    this.maxAge = totalMinutes * 60 * 20;
                    break;
                }
                case 3: {
                    this.maxAge = 3600;
                    break;
                }
                case 4: {
                    this.maxAge = Integer.MAX_VALUE;
                }
            }
        }

        protected void m_8097_() {
            this.f_19804_.m_135372_(TARGET_DIM, (Object)"minecraft:overworld");
            this.f_19804_.m_135372_(CREATOR_LEVEL, (Object)1);
            this.f_19804_.m_135372_(TIER, (Object)2);
            this.f_19804_.m_135372_(STABILIZATION, (Object)0);
            this.f_19804_.m_135372_(STATE, (Object)0);
            this.f_19804_.m_135372_(STITCH_INDEX, (Object)0);
            this.f_19804_.m_135372_(PLAYER_ID, Optional.empty());
            this.f_19804_.m_135372_(STITCH_POINTS_DATA, (Object)new CompoundTag());
        }

        public boolean m_6094_() {
            return false;
        }

        public void m_7334_(Entity entity) {
        }

        public boolean m_6087_() {
            return true;
        }

        public void m_8119_() {
            super.m_8119_();
            ++this.age;
            this.m_20095_();
            this.m_20331_(true);
            this.m_20115_(0, false);
            if (!this.m_9236_().f_46443_) {
                int tier = this.getTier();
                List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, this.m_20191_().m_82400_(4.0));
                for (ServerPlayer p : nearbyPlayers) {
                    this.performRiftAction(p);
                }
                if (tier == 3 && this.getRiftState() == 0) {
                    List stitchingPlayers = this.m_9236_().m_45976_(ServerPlayer.class, this.m_20191_().m_82400_(7.0));
                    for (ServerPlayer p : stitchingPlayers) {
                        if (p.m_21205_().m_41720_() != ModRegistry.WEAVERS_NEEDLE.get()) continue;
                        AtomicBoolean canStart = new AtomicBoolean(false);
                        p.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                            if (cap.getVorial() >= 10) {
                                canStart.set(true);
                            }
                        });
                        if (!canStart.get()) break;
                        this.startStitching(p);
                        p.m_20091_();
                        break;
                    }
                }
                if (tier == 3 && this.getRiftState() == 1) {
                    this.drainVorialAndCheckInterrupt((ServerLevel)this.m_9236_());
                }
                if (this.age >= this.maxAge && tier != 4) {
                    this.handleLifecycleEnd(tier);
                    return;
                }
                if (this.age % 20 == 0) {
                    this.refreshRiftName(tier);
                    this.applyAreaEffects(tier);
                }
                if (tier == 2 && this.age % 6000 == 0) {
                    this.impactChunkStability(-0.5f);
                }
                if (tier == 2) {
                    this.pullEntities(0.15);
                } else if (tier == 3) {
                    this.pullEntities(0.25);
                } else if (tier == 4) {
                    this.pullEntities(0.4);
                    this.annihilateEntities();
                    if (this.age % 20 == 0) {
                        this.impactChunkStability(-5.0f);
                    }
                }
                if (!this.m_9236_().f_46443_ && this.m_9236_().m_46472_().equals(IntersticeHandler.INTERSTICE_KEY)) {
                    this.m_146870_();
                    return;
                }
            } else {
                this.spawnVisuals();
            }
        }

        private void annihilateEntities() {
            double radius = 2.5;
            AABB killZone = this.m_20191_().m_82400_(radius);
            List victims = this.m_9236_().m_45933_((Entity)this, killZone);
            for (Entity e : victims) {
                boolean shouldDestroy;
                if (e instanceof Player || e == this || !(shouldDestroy = e instanceof ItemEntity || e instanceof Projectile || e instanceof LivingEntity) || !e.m_6084_()) continue;
                e.m_146870_();
                this.m_9236_().m_6263_(null, e.m_20185_(), e.m_20186_(), e.m_20189_(), SoundEvents.f_144098_, SoundSource.NEUTRAL, 1.0f, 2.0f);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, e.m_20185_(), e.m_20186_(), e.m_20189_(), 5, 0.2, 0.5, 0.2, 0.0);
            }
        }

        public boolean addStabilization() {
            int required;
            int current = this.getStabilization();
            int next = current + 1;
            this.setStabilization(next);
            int tier = this.getTier();
            int n = tier >= 4 ? 4 : (required = tier == 3 ? 3 : 1);
            if (next >= required) {
                this.m_146870_();
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12513_, SoundSource.AMBIENT, 1.0f, 1.0f);
                this.impactChunkStability(50.0f);
                return true;
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11668_, SoundSource.AMBIENT, 0.5f, 0.5f);
            return false;
        }

        private void refreshRiftName(int tier) {
            if (tier <= 2) {
                String colorCode;
                int secondsLeft = (this.maxAge - this.age) / 20;
                String timeStr = String.format("%02d:%02d", secondsLeft / 60, secondsLeft % 60);
                String string = tier == 1 ? "\u00a7a" : (colorCode = tier == 2 ? "\u00a7e" : "\u00a7c");
                String tierName = tier == 1 ? "I" : (tier == 2 ? "II" : "III");
                this.m_6593_((Component)Component.m_237113_((String)(colorCode + "\u0420\u0430\u0437\u043b\u043e\u043c \u041a\u043b\u0430\u0441\u0441\u0430 " + tierName + " \u00a77[" + timeStr + "]")));
                this.m_20340_(true);
            } else {
                String colorCode = tier == 3 ? "\u00a7c" : "\u00a74";
                String tierName = tier == 3 ? "III" : "IV";
                this.m_6593_((Component)Component.m_237113_((String)(colorCode + "\u0420\u0430\u0437\u043b\u043e\u043c \u041a\u043b\u0430\u0441\u0441\u0430 " + tierName)));
                this.m_20340_(true);
            }
        }

        public void m_6123_(Player player) {
            if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.performRiftAction(serverPlayer);
            }
        }

        private void performRiftAction(ServerPlayer player) {
            if (player.m_20092_()) {
                return;
            }
            int tier = this.getTier();
            switch (tier) {
                case 1: {
                    this.randomTeleportNearby(player, 5);
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7b\u042d\u0442\u043e \u0432\u0441\u0435\u0433\u043e \u043b\u0438\u0448\u044c \u044d\u0445\u043e..."), true);
                    player.m_20091_();
                    break;
                }
                case 2: {
                    if (!((double)player.m_20270_((Entity)this) < 1.5)) break;
                    if (this.processRiftInteraction(player, 45, 45, 5)) {
                        this.m_146870_();
                    }
                    player.m_20091_();
                    break;
                }
                case 3: {
                    if (this.getRiftState() == 1 || !((double)player.m_20270_((Entity)this) < 2.0)) break;
                    this.processRiftInteraction(player, 30, 50, 15);
                    player.m_20091_();
                    break;
                }
                case 4: {
                    if (!((double)player.m_20270_((Entity)this) < 3.0)) break;
                    this.teleportToVoid(player);
                    player.m_20091_();
                }
            }
        }

        private void applyAreaEffects(int tier) {
            double radius = tier == 4 ? 20.0 : 10.0;
            AABB area = this.m_20191_().m_82400_(radius);
            List players = this.m_9236_().m_45976_(Player.class, area);
            for (Player p : players) {
                switch (tier) {
                    case 1: {
                        p.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                            int max = VorialCapability.getMaxVorial(p);
                            if (cap.getVorial() < max) {
                                cap.addVorial(p, 5);
                                VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)p), (Object)new VorialSyncPacket(cap.getVorial(), cap.isSuppressed()));
                            }
                        });
                        break;
                    }
                    case 2: {
                        p.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 0, true, true));
                        p.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 40, 0, true, true));
                        break;
                    }
                    case 4: {
                        ItemStack hand;
                        if (p.m_7500_() || (hand = p.m_21205_()).m_41619_()) break;
                        p.m_36176_(hand.m_41777_(), true);
                        p.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                        p.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u0421\u0442\u0438\u0433\u043c\u0430\u0442 \u043e\u0442\u0432\u0435\u0440\u0433\u0430\u0435\u0442 \u043c\u0430\u0442\u0435\u0440\u0438\u044e!"), true);
                    }
                }
            }
        }

        private void pullEntities(double strength) {
            AABB area = this.m_20191_().m_82400_(12.0);
            List entities = this.m_9236_().m_45933_((Entity)this, area);
            Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
            for (Entity e : entities) {
                Player p;
                if (e instanceof Player && ((p = (Player)e).m_7500_() || p.m_5833_()) || e == this) continue;
                Vec3 dir = center.m_82546_(e.m_20182_()).m_82541_();
                double dist = e.m_20270_((Entity)this);
                double factor = (12.0 - dist) / 12.0;
                double finalStrength = strength * (0.5 + factor);
                if (e instanceof Player) {
                    finalStrength *= 3.5;
                }
                Vec3 pull = dir.m_82490_(finalStrength);
                e.m_20256_(e.m_20184_().m_82549_(pull));
                e.f_19864_ = true;
                if (!(e instanceof ServerPlayer)) continue;
                ServerPlayer sp = (ServerPlayer)e;
                sp.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)sp));
            }
        }

        private void applyGravityInversion() {
            AABB area = this.m_20191_().m_82400_(10.0);
            List entities = this.m_9236_().m_45933_((Entity)this, area);
            for (Entity e : entities) {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 10, 2, false, false));
                    continue;
                }
                e.m_20256_(e.m_20184_().m_82520_(0.0, 0.08, 0.0));
            }
        }

        private void drainVorialAndCheckInterrupt(ServerLevel level) {
            UUID pid = this.getPlayerID();
            if (pid == null) {
                this.abortStitching(null, "\u041f\u0440\u0435\u0440\u0432\u0430\u043d\u043e: \u0418\u0433\u0440\u043e\u043a \u043f\u0440\u043e\u043f\u0430\u043b.");
                return;
            }
            ServerPlayer player = level.m_7654_().m_6846_().m_11259_(pid);
            if (player == null || player.m_213877_() || player.m_21205_().m_41720_() != ModRegistry.WEAVERS_NEEDLE.get()) {
                this.abortStitching(player, "\u041f\u0440\u0435\u0440\u0432\u0430\u043d\u043e: \u0418\u0433\u0440\u043e\u043a \u043e\u0442\u043e\u0448\u0435\u043b \u0438\u043b\u0438 \u043f\u043e\u0442\u0435\u0440\u044f\u043b \u0418\u0433\u043b\u0443.");
                return;
            }
            player.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                if (cap.getVorial() < 1) {
                    this.abortStitching(player, "\u041f\u0440\u0435\u0440\u0432\u0430\u043d\u043e: \u0412\u043e\u0440\u0438\u0430\u043b\u044c \u0438\u0441\u0441\u044f\u043a.");
                    return;
                }
                cap.removeVorial(1);
                VorialNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new VorialSyncPacket(cap.getVorial(), cap.isSuppressed()));
            });
        }

        public void startStitching(ServerPlayer player) {
            Player ownerEntity;
            UUID currentOwner;
            if (this.getRiftState() == 1 && (currentOwner = this.getPlayerID()) != null && !currentOwner.equals(player.m_20148_()) && (ownerEntity = this.m_9236_().m_46003_(currentOwner)) != null && ownerEntity.m_6084_() && ownerEntity.m_20280_((Entity)this) < 256.0) {
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7c\u042d\u0442\u043e\u0442 \u0440\u0430\u0437\u043b\u043e\u043c \u0443\u0436\u0435 \u0441\u0448\u0438\u0432\u0430\u0435\u0442 " + ownerEntity.m_7755_().getString())), true);
                return;
            }
            if (this.getTier() != 3) {
                return;
            }
            this.setRiftState(1);
            this.setPlayerID(player.m_20148_());
            this.setStitchIndex(0);
            CompoundTag pointsTag = this.generateStitchPoints();
            this.setStitchPoints(pointsTag);
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7d\u0421\u0448\u0438\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0447\u0430\u0442\u043e. \u0421\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u0435 \u0442\u043e\u0447\u043a\u0438 \u0412\u043e\u0440\u0438\u0430\u043b\u044f \u0418\u0433\u043b\u043e\u0439."), true);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_144243_, SoundSource.MASTER, 1.0f, 1.5f);
        }

        public void progressStitch(ServerPlayer player, int clickedIndex) {
            if (this.getRiftState() != 1 || !player.m_20148_().equals(this.getPlayerID())) {
                return;
            }
            int current = this.getStitchIndex();
            if (clickedIndex == current) {
                this.setStitchIndex(current + 1);
                if (current + 1 >= 4) {
                    this.closeStitchingRift(player);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7a\u0428\u043e\u0432 " + (current + 1) + " \u0433\u043e\u0442\u043e\u0432.")), true);
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundEvents.f_12214_.m_203334_(), SoundSource.MASTER, 0.5f, 1.5f);
                }
            } else {
                player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0430!"), true);
                this.abortStitching(player, "\u041f\u0440\u0435\u0440\u0432\u0430\u043d\u043e: \u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438.");
            }
        }

        public void abortStitching(ServerPlayer player, String reason) {
            if (this.getRiftState() != 1) {
                return;
            }
            this.setRiftState(0);
            this.setStitchIndex(0);
            this.setPlayerID(null);
            this.age = 0;
            if (player != null) {
                player.m_147240_(1.0, this.m_20185_() - player.m_20185_(), this.m_20189_() - player.m_20189_());
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7c" + reason)), true);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12018_, SoundSource.MASTER, 1.0f, 0.5f);
        }

        private void closeStitchingRift(ServerPlayer player) {
            this.m_146870_();
            this.impactChunkStability(20.0f);
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7a\u0420\u0430\u0437\u043b\u043e\u043c \u0437\u0430\u043a\u0440\u044b\u0442! \u042d\u0444\u0438\u0440\u043d\u0430\u044f \u0445\u0438\u0440\u0443\u0440\u0433\u0438\u044f \u0443\u0434\u0430\u043b\u0430\u0441\u044c."), true);
            if (this.visualRandom.nextFloat() < 0.4f) {
                this.m_19998_((ItemLike)ModRegistry.RIFT_HEART.get());
                player.m_5661_((Component)Component.m_237113_((String)"\u00a75\u0412\u044b \u0432\u044b\u0440\u0432\u0430\u043b\u0438 \u0441\u0435\u0440\u0434\u0446\u0435 \u0440\u0430\u0437\u043b\u043e\u043c\u0430..."), false);
            }
        }

        private CompoundTag generateStitchPoints() {
            Random r = new Random();
            CompoundTag tag = new CompoundTag();
            double radius = 5.0;
            for (int i = 0; i < 4; ++i) {
                double angle = (double)i * 90.0 * (Math.PI / 180);
                double x = Math.cos(angle) * radius;
                double z = Math.sin(angle) * radius;
                double y = r.nextDouble() * 2.0 - 1.0;
                CompoundTag point = new CompoundTag();
                point.m_128347_("x", x);
                point.m_128347_("y", y);
                point.m_128347_("z", z);
                tag.m_128365_(String.valueOf(i), (Tag)point);
            }
            return tag;
        }

        private void handleLifecycleEnd(int tier) {
            Random r = new Random();
            float chunkStability = this.getChunkStability();
            int roll = r.nextInt(100);
            if (tier == 1) {
                if (roll < 30) {
                    this.closeRift("\u042d\u0445\u043e \u0440\u0430\u0441\u0442\u0432\u043e\u0440\u0438\u043b\u043e\u0441\u044c.");
                } else if (roll < 70) {
                    this.evolveTo(2);
                } else {
                    this.extendLife(180 + r.nextInt(120));
                }
            } else if (tier == 2) {
                if (chunkStability >= 60.0f) {
                    if (roll < 40) {
                        this.closeRift("\u0420\u0430\u0437\u0440\u044b\u0432 \u0437\u0430\u0442\u044f\u043d\u0443\u043b\u0441\u044f \u0441\u0430\u043c.");
                    } else if (roll < 80) {
                        this.extendLife(120 + r.nextInt(60));
                    } else {
                        this.evolveTo(3);
                    }
                } else if (roll < 30) {
                    this.closeRift("\u0420\u0430\u0437\u0440\u044b\u0432 \u0437\u0430\u0442\u044f\u043d\u0443\u043b\u0441\u044f \u0447\u0443\u0434\u043e\u043c.");
                } else if (roll < 60) {
                    this.extendLife(120 + r.nextInt(60));
                } else {
                    this.evolveTo(3);
                }
            } else if (tier == 3) {
                if (chunkStability >= 60.0f) {
                    if (roll < 25) {
                        this.closeRift("\u042f\u0437\u0432\u0430 \u0438\u0441\u0446\u0435\u043b\u0438\u043b\u0430\u0441\u044c.");
                    } else {
                        this.extendLife(60);
                    }
                } else if (roll < 25) {
                    this.closeRift("\u042f\u0437\u0432\u0430 \u0438\u0441\u0447\u0435\u0437\u043b\u0430.");
                } else if (roll < 75) {
                    this.extendLife(60);
                } else {
                    this.evolveTo(4);
                }
            }
        }

        private void closeRift(String reason) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144242_, SoundSource.AMBIENT, 1.0f, 1.0f);
            this.m_146870_();
        }

        private void extendLife(int seconds) {
            this.age = 0;
            this.maxAge = seconds * 20;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12376_, SoundSource.AMBIENT, 1.0f, 0.5f);
        }

        private void evolveTo(int newTier) {
            this.setTier(newTier);
            this.setStabilization(0);
            this.age = 0;
            this.calculateDefaultLifespan(newTier, this.getCreatorLevel());
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12644_, SoundSource.AMBIENT, 1.0f, 0.5f);
            this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(50.0)).forEach(p -> p.m_5661_((Component)Component.m_237113_((String)("\u00a7c\u26a0 \u0420\u0430\u0437\u043b\u043e\u043c \u044d\u0432\u043e\u043b\u044e\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043b \u0434\u043e \u041a\u043b\u0430\u0441\u0441\u0430 " + newTier + "!")), true));
        }

        private float getChunkStability() {
            LevelChunk chunk = this.m_9236_().m_46745_(this.m_20183_());
            AtomicReference<Float> stab = new AtomicReference<Float>(Float.valueOf(100.0f));
            chunk.getCapability(ChunkStability.INSTANCE).ifPresent(cap -> stab.set(Float.valueOf(cap.getStability())));
            return stab.get().floatValue();
        }

        private void impactChunkStability(float amount) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                LevelChunk chunk = serverLevel.m_46745_(this.m_20183_());
                chunk.getCapability(ChunkStability.INSTANCE).ifPresent(cap -> {
                    cap.addStability(amount);
                    ChunkStabilityHandler.sendSyncPacket(serverLevel, chunk.m_7697_(), cap.getStability());
                });
            }
        }

        private void randomTeleportNearby(ServerPlayer player, int distance) {
            double x = player.m_20185_() + (this.visualRandom.nextDouble() - 0.5) * (double)distance * 2.0;
            double y = player.m_20186_();
            double z = player.m_20189_() + (this.visualRandom.nextDouble() - 0.5) * (double)distance * 2.0;
            player.m_6021_(x, y, z);
        }

        private boolean processRiftInteraction(ServerPlayer player, int success, int randomDim, int death) {
            Random rand = new Random();
            int roll = rand.nextInt(100);
            int t1 = success;
            int t2 = success + randomDim;
            int t3 = success + randomDim + death;
            if (roll < t1) {
                this.teleportToTarget(player);
                return true;
            }
            if (roll < t2) {
                this.teleportToRandom(player);
                return true;
            }
            if (roll < t3) {
                this.teleportToVoid(player);
                return true;
            }
            if (this.getTier() == 2) {
                this.triggerCascadingResonance();
            } else {
                this.triggerChainReaction();
            }
            player.m_147240_(2.5, player.m_20185_() - this.m_20185_(), player.m_20189_() - this.m_20189_());
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u0420\u0430\u0437\u043b\u043e\u043c \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u0435\u043d!"));
            return false;
        }

        private void triggerCascadingResonance() {
            this.evolveTo(3);
            ServerLevel level = (ServerLevel)this.m_9236_();
            int echoCount = 2 + this.visualRandom.nextInt(2);
            for (int i = 0; i < echoCount; ++i) {
                double angle = this.visualRandom.nextDouble() * Math.PI * 2.0;
                double dist = 5.0 + this.visualRandom.nextDouble() * 5.0;
                double nx = this.m_20185_() + Math.cos(angle) * dist;
                double nz = this.m_20189_() + Math.sin(angle) * dist;
                double ny = this.m_20186_() + (this.visualRandom.nextDouble() - 0.5) * 2.0;
                RiftEntity echo = new RiftEntity((Level)level, nx, ny, nz, this.getTargetDimension(), this.getCreatorLevel(), 1);
                level.m_7967_((Entity)echo);
            }
            level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215771_, SoundSource.HOSTILE, 2.0f, 0.5f);
            level.m_45976_(Player.class, this.m_20191_().m_82400_(30.0)).forEach(p -> {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 1));
                p.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 600, 0));
                p.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u26a0 \u041a\u0410\u0421\u041a\u0410\u0414\u041d\u042b\u0419 \u0420\u0415\u0417\u041e\u041d\u0410\u041d\u0421!"), true);
            });
        }

        private void triggerChainReaction() {
            ServerLevel level = (ServerLevel)this.m_9236_();
            Random rand = new Random();
            int count = 1 + rand.nextInt(2);
            block0: for (int i = 0; i < count; ++i) {
                for (int attempt = 0; attempt < 5; ++attempt) {
                    double angle = rand.nextDouble() * Math.PI * 2.0;
                    double dist = 12.0 + rand.nextDouble() * 6.0;
                    double nx = this.m_20185_() + Math.cos(angle) * dist;
                    double nz = this.m_20189_() + Math.sin(angle) * dist;
                    double ny = this.m_20186_() + (rand.nextDouble() - 0.5) * 4.0;
                    BlockPos targetPos = BlockPos.m_274561_((double)nx, (double)ny, (double)nz);
                    if (!level.m_8055_(targetPos).m_60795_() || !level.m_8055_(targetPos.m_7494_()).m_60795_()) continue;
                    RiftEntity newRift = new RiftEntity((Level)level, nx, ny, nz, this.getTargetDimension(), this.getCreatorLevel(), this.getTier());
                    level.m_7967_((Entity)newRift);
                    continue block0;
                }
            }
            level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.AMBIENT, 1.0f, 0.5f);
        }

        private void teleportToTarget(ServerPlayer player) {
            String dimId = this.getTargetDimension();
            ResourceLocation loc = ResourceLocation.m_135820_((String)dimId);
            if (loc == null) {
                return;
            }
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)loc);
            this.teleportLogic(player, (ResourceKey<Level>)key);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u0412\u044b \u043f\u0440\u043e\u0448\u043b\u0438 \u0441\u043a\u0432\u043e\u0437\u044c \u0440\u0430\u0437\u043b\u043e\u043c."));
        }

        private void teleportToRandom(ServerPlayer player) {
            String[] ids = new String[]{"minecraft:overworld", "minecraft:the_nether", "junctionworlds:helheim", "junctionworlds:amenti"};
            if (ids.length == 0) {
                return;
            }
            String randomId = ids[this.m_9236_().f_46441_.m_188503_(ids.length)];
            ResourceLocation loc = ResourceLocation.m_135820_((String)randomId);
            if (loc == null) {
                return;
            }
            this.teleportLogic(player, (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)loc));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u0420\u0430\u0437\u043b\u043e\u043c \u0432\u044b\u043f\u043b\u044e\u043d\u0443\u043b \u0432\u0430\u0441 \u0432 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0441\u0442\u0438..."));
        }

        private void teleportToVoid(ServerPlayer player) {
            ResourceKey<Level> key = IntersticeHandler.INTERSTICE_KEY;
            ServerLevel targetLevel = player.m_20194_().m_129880_(key);
            if (targetLevel != null) {
                player.m_8999_(targetLevel, player.m_20185_(), 300.0, player.m_20189_(), player.m_146908_(), player.m_146909_());
                player.m_213846_((Component)Component.m_237113_((String)"\u00a74\u0420\u0430\u0437\u043b\u043e\u043c \u0432\u0435\u043b \u0432 \u043d\u0438\u043a\u0443\u0434\u0430..."));
            }
        }

        private void teleportLogic(ServerPlayer player, ResourceKey<Level> dimKey) {
            ServerLevel targetLevel = player.m_20194_().m_129880_(dimKey);
            if (targetLevel != null) {
                BlockPos safePos = TeleportRequestPacket.findSafeTeleportSpot(targetLevel, player);
                boolean blockedHead = AterceniteManager.isLocationInField((Level)targetLevel, safePos.m_7494_());
                boolean blockedFeet = AterceniteManager.isLocationInField((Level)targetLevel, safePos);
                if (blockedHead || blockedFeet) {
                    player.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u0420\u0430\u0437\u043b\u043e\u043c \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u043e\u0431\u0438\u0442\u044c \u0437\u0430\u0449\u0438\u0442\u0443 \u0410\u0442\u0435\u0440\u0446\u0435\u043d\u0438\u0442\u0430..."), true);
                    Vec3 push = player.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(1.5);
                    player.m_20256_(push);
                    player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                    return;
                }
                player.m_8999_(targetLevel, (double)safePos.m_123341_() + 0.5, (double)safePos.m_123342_(), (double)safePos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            }
        }

        private void spawnVisuals() {
            if (this.f_19797_ % 2 != 0) {
                return;
            }
            int tier = this.getTier();
            Random fixedRandom = new Random(this.m_20148_().getLeastSignificantBits());
            Vec3 centerPos = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() / 2.0, 0.0);
            switch (tier) {
                case 1: {
                    for (int i = 0; i < 1; ++i) {
                        double yOff = (this.visualRandom.nextDouble() - 0.5) * 1.5;
                        double xOff = (this.visualRandom.nextDouble() - 0.5) * 0.8;
                        double zOff = (this.visualRandom.nextDouble() - 0.5) * 0.8;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123751_, centerPos.f_82479_ + xOff, centerPos.f_82480_ + yOff, centerPos.f_82481_ + zOff, 0.0, 0.0, 0.0);
                        if (!(this.visualRandom.nextFloat() < 0.2f)) continue;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, centerPos.f_82479_ + xOff, centerPos.f_82480_ + yOff, centerPos.f_82481_ + zOff, 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case 2: {
                    this.spawnConvergingLightning(fixedRandom, centerPos, COLOR_WHITE, COLOR_PURPLE, 1.0f);
                    break;
                }
                case 3: {
                    float pulse = 1.0f + Mth.m_14031_((float)((float)this.age * 0.1f)) * 0.3f;
                    this.spawnConvergingLightning(fixedRandom, centerPos, COLOR_TOXIC_GREEN, COLOR_BLACK, pulse);
                    if (!(this.visualRandom.nextFloat() < 0.3f)) break;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123765_, centerPos.f_82479_, centerPos.f_82480_ - 1.0, centerPos.f_82481_, (this.visualRandom.nextDouble() - 0.5) * 0.1, -0.1, (this.visualRandom.nextDouble() - 0.5) * 0.1);
                    break;
                }
                case 4: {
                    this.spawnHungryVoidVisuals(centerPos);
                }
            }
            if (this.getTier() == 3 && this.getRiftState() == 1) {
                this.renderStitchPoints(centerPos);
            }
        }

        private void renderStitchPoints(Vec3 riftCenter) {
            Entity player;
            CompoundTag pointsTag = this.getStitchPoints();
            int currentIndex = this.getStitchIndex();
            Vec3 prevPoint = null;
            for (int i = 0; i < 4; ++i) {
                String key = String.valueOf(i);
                if (!pointsTag.m_128441_(key)) continue;
                CompoundTag pTag = pointsTag.m_128469_(key);
                Vec3 pointPos = riftCenter.m_82520_(pTag.m_128459_("x"), pTag.m_128459_("y"), pTag.m_128459_("z"));
                if (i < currentIndex) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, pointPos.f_82479_, pointPos.f_82480_, pointPos.f_82481_, 0.0, 0.0, 0.0);
                } else if (i == currentIndex) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, pointPos.f_82479_, pointPos.f_82480_, pointPos.f_82481_, 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.8f, 0.0f), 1.0f), pointPos.f_82479_, pointPos.f_82480_, pointPos.f_82481_, 0.0, 0.0, 0.0);
                } else {
                    this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.5f, 0.5f), 0.8f), pointPos.f_82479_, pointPos.f_82480_, pointPos.f_82481_, 0.0, 0.0, 0.0);
                }
                if (i > 0 && i <= currentIndex && prevPoint != null) {
                    this.drawParticleLine(prevPoint, pointPos, new Vector3f(0.2f, 1.0f, 0.2f));
                }
                prevPoint = pointPos;
            }
            if (currentIndex < 4 && prevPoint != null && (player = this.m_9236_().m_6815_(this.getPlayerID().hashCode())) != null) {
                this.drawParticleLine(prevPoint, player.m_20299_(1.0f).m_82492_(0.0, 0.3, 0.0), new Vector3f(1.0f, 0.8f, 0.0f));
            }
        }

        private void drawParticleLine(Vec3 start, Vec3 end, Vector3f color) {
            double dist = start.m_82554_(end);
            int count = (int)(dist * 3.0);
            for (int i = 0; i <= count; ++i) {
                double t = (double)i / (double)count;
                Vec3 pos = start.m_165921_(end, t);
                this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(color, 0.5f), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        }

        private void spawnHungryVoidVisuals(Vec3 center) {
            float time = (float)this.age * 0.04f;
            Random structureRand = new Random(this.m_20148_().getLeastSignificantBits());
            for (int i = 0; i < 8; ++i) {
                Vec3 dir = new Vec3(this.visualRandom.nextDouble() - 0.5, this.visualRandom.nextDouble() - 0.5, this.visualRandom.nextDouble() - 0.5).m_82541_();
                Vec3 pos = center.m_82549_(dir.m_82490_(0.8 + this.visualRandom.nextDouble() * 0.4));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123765_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
                if (!this.visualRandom.nextBoolean()) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123783_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
            if (this.visualRandom.nextFloat() < 0.6f) {
                double range = 3.5;
                double px = center.f_82479_ + (this.visualRandom.nextDouble() - 0.5) * range * 2.0;
                double py = center.f_82480_ + (this.visualRandom.nextDouble() - 0.5) * range * 2.0;
                double pz = center.f_82481_ + (this.visualRandom.nextDouble() - 0.5) * range * 2.0;
                Vec3 motion = center.m_82492_(px, py, pz).m_82541_().m_82490_(0.2);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, px, py, pz, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
            int tentaclesCount = 5 + structureRand.nextInt(3);
            for (int i = 0; i < tentaclesCount; ++i) {
                Vec3 directionVector = new Vec3(structureRand.nextDouble() - 0.5, structureRand.nextDouble() - 0.5, structureRand.nextDouble() - 0.5).m_82541_();
                float length = 4.0f + structureRand.nextFloat() * 5.0f;
                int segments = 40;
                for (int j = 0; j <= segments; ++j) {
                    double veinPulse;
                    float t = (float)j / (float)segments;
                    Vec3 currentBasePos = center.m_82549_(directionVector.m_82490_((double)(t * length)));
                    double wobbleAmplitude = (double)t * 0.8;
                    double wX = Math.sin((double)time * 1.2 + (double)i * 2.0 + (double)t * Math.PI * 3.0) * wobbleAmplitude;
                    double wY = Math.cos((double)time * 1.4 + (double)i * 3.0 + (double)t * Math.PI * 2.0) * wobbleAmplitude;
                    double wZ = Math.sin((double)time * 1.1 + (double)i * 4.0 + (double)t * Math.PI * 4.0) * wobbleAmplitude;
                    double slowDrift = Math.sin((double)time * 0.3 + (double)i);
                    Vec3 finalPos = currentBasePos.m_82520_(wX += slowDrift * (double)t * 0.3, wY, wZ += Math.cos((double)time * 0.3 + (double)i) * (double)t * 0.3);
                    if (j > 5) {
                        this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(COLOR_OBSIDIAN, 0.7f), finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, 0.0, 0.0, 0.0);
                    }
                    if ((veinPulse = Math.sin((double)time * 2.5 - (double)t * 8.0 + (double)i)) > 0.9 && j % 4 == 0) {
                        Vector3f veinColor = this.visualRandom.nextBoolean() ? COLOR_VEIN_PURPLE : COLOR_VEIN_BLUE;
                        this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(veinColor, 0.9f), finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, 0.0, 0.0, 0.0);
                    }
                    if (j != segments) continue;
                    this.drawTentacleHand(finalPos, directionVector, time + (float)i);
                }
            }
        }

        private void drawTentacleHand(Vec3 tipPos, Vec3 tentacleDir, double localTime) {
            Vec3 upish = new Vec3(0.0, 1.0, 0.0);
            if (Math.abs(tentacleDir.m_82526_(upish)) > 0.9) {
                upish = new Vec3(1.0, 0.0, 0.0);
            }
            Vec3 perp1 = tentacleDir.m_82537_(upish).m_82541_();
            Vec3 perp2 = tentacleDir.m_82537_(perp1).m_82541_();
            for (int f = 0; f < 3; ++f) {
                double angle = (double)f * 2.0943951023931953 + localTime * 0.5;
                double grasp = 0.3 + Math.sin(localTime * 1.5) * 0.15;
                Vec3 fingerDirSpread = perp1.m_82490_(Math.cos(angle)).m_82549_(perp2.m_82490_(Math.sin(angle))).m_82541_();
                Vec3 fingerFinalDir = tentacleDir.m_82490_(0.5).m_82549_(fingerDirSpread.m_82490_(grasp)).m_82541_();
                for (int p = 1; p <= 3; ++p) {
                    double fingerLength = 0.8 * ((double)p / 3.0);
                    Vec3 particlePos = tipPos.m_82549_(fingerFinalDir.m_82490_(fingerLength));
                    this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(COLOR_OBSIDIAN, 0.6f), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }

        private void spawnConvergingLightning(Random fixedRandom, Vec3 centerPos, Vector3f colorStart, Vector3f colorEnd, float scale) {
            int rays = 8 + fixedRandom.nextInt(4);
            if (this.visualRandom.nextFloat() < 0.5f) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123747_, centerPos.f_82479_, centerPos.f_82480_, centerPos.f_82481_, 0.0, 0.0, 0.0);
            }
            for (int i = 0; i < rays; ++i) {
                Vec3 dir = new Vec3(fixedRandom.nextDouble() - 0.5, fixedRandom.nextDouble() - 0.5, fixedRandom.nextDouble() - 0.5).m_82541_();
                double length = (4.0 + fixedRandom.nextDouble() * 3.0) * (double)scale;
                Vec3 endPos = centerPos.m_82549_(dir.m_82490_(length));
                this.drawJaggedLightning(centerPos, endPos, fixedRandom, 0.3f, centerPos, colorStart, colorEnd);
            }
        }

        private void drawJaggedLightning(Vec3 start, Vec3 end, Random random, float chaos, Vec3 absoluteCenter, Vector3f cStart, Vector3f cEnd) {
            double distance = start.m_82554_(end);
            if (distance < 0.7) {
                this.drawLineWithGradient(start, end, absoluteCenter, cStart, cEnd);
                return;
            }
            Vec3 mid = start.m_165921_(end, 0.5);
            Vec3 direction = end.m_82546_(start).m_82541_();
            Vec3 perp = direction.m_82537_(new Vec3(0.0, 1.0, 0.0));
            if (perp.m_82556_() < 0.001) {
                perp = direction.m_82537_(new Vec3(1.0, 0.0, 0.0));
            }
            perp = perp.m_82541_().m_82524_((float)(random.nextDouble() * Math.PI * 2.0));
            double offsetScale = distance * (double)chaos;
            Vec3 offset = perp.m_82490_((random.nextDouble() - 0.5) * 2.0 * offsetScale);
            mid = mid.m_82549_(offset);
            this.drawJaggedLightning(start, mid, random, chaos * 0.65f, absoluteCenter, cStart, cEnd);
            this.drawJaggedLightning(mid, end, random, chaos * 0.65f, absoluteCenter, cStart, cEnd);
        }

        private void drawLineWithGradient(Vec3 start, Vec3 end, Vec3 absoluteCenter, Vector3f cStart, Vector3f cEnd) {
            double segmentDist = start.m_82554_(end);
            int particlesCount = Math.max(1, (int)(segmentDist * 3.0));
            for (int i = 0; i <= particlesCount; ++i) {
                double t = (double)i / (double)particlesCount;
                Vec3 pos = start.m_165921_(end, t);
                double distToCenter = pos.m_82554_(absoluteCenter);
                double maxRadius = 7.0;
                float blendFactor = (float)Mth.m_14008_((double)(distToCenter / maxRadius), (double)0.0, (double)1.0);
                Vector3f color = new Vector3f(Mth.m_14179_((float)blendFactor, (float)cStart.x(), (float)cEnd.x()), Mth.m_14179_((float)blendFactor, (float)cStart.y(), (float)cEnd.y()), Mth.m_14179_((float)blendFactor, (float)cStart.z(), (float)cEnd.z()));
                float size = 1.2f - blendFactor * 0.7f;
                this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(color, size), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        }

        public void setTargetDimension(String dim) {
            this.f_19804_.m_135381_(TARGET_DIM, (Object)dim);
        }

        public String getTargetDimension() {
            return (String)this.f_19804_.m_135370_(TARGET_DIM);
        }

        public void setCreatorLevel(int lvl) {
            this.f_19804_.m_135381_(CREATOR_LEVEL, (Object)lvl);
        }

        public int getCreatorLevel() {
            return (Integer)this.f_19804_.m_135370_(CREATOR_LEVEL);
        }

        public void setTier(int tier) {
            this.f_19804_.m_135381_(TIER, (Object)tier);
        }

        public int getTier() {
            return (Integer)this.f_19804_.m_135370_(TIER);
        }

        public void setStabilization(int val) {
            this.f_19804_.m_135381_(STABILIZATION, (Object)val);
        }

        public int getStabilization() {
            return (Integer)this.f_19804_.m_135370_(STABILIZATION);
        }

        public int getRiftState() {
            return (Integer)this.f_19804_.m_135370_(STATE);
        }

        public void setRiftState(int state) {
            this.f_19804_.m_135381_(STATE, (Object)state);
        }

        public int getStitchIndex() {
            return (Integer)this.f_19804_.m_135370_(STITCH_INDEX);
        }

        public void setStitchIndex(int index) {
            this.f_19804_.m_135381_(STITCH_INDEX, (Object)index);
        }

        public UUID getPlayerID() {
            return ((Optional)this.f_19804_.m_135370_(PLAYER_ID)).orElse(null);
        }

        public void setPlayerID(UUID id) {
            this.f_19804_.m_135381_(PLAYER_ID, Optional.ofNullable(id));
        }

        public CompoundTag getStitchPoints() {
            return (CompoundTag)this.f_19804_.m_135370_(STITCH_POINTS_DATA);
        }

        public void setStitchPoints(CompoundTag tag) {
            this.f_19804_.m_135381_(STITCH_POINTS_DATA, (Object)tag);
        }

        protected void m_7378_(CompoundTag tag) {
            this.age = tag.m_128451_("Age");
            if (tag.m_128441_("TargetDim")) {
                this.setTargetDimension(tag.m_128461_("TargetDim"));
            }
            if (tag.m_128441_("CreatorLvl")) {
                this.setCreatorLevel(tag.m_128451_("CreatorLvl"));
            }
            if (tag.m_128441_("Tier")) {
                this.setTier(tag.m_128451_("Tier"));
            }
            if (tag.m_128441_("Stabilization")) {
                this.setStabilization(tag.m_128451_("Stabilization"));
            }
            if (tag.m_128441_("RiftState")) {
                this.setRiftState(tag.m_128451_("RiftState"));
            }
            if (tag.m_128441_("StitchIndex")) {
                this.setStitchIndex(tag.m_128451_("StitchIndex"));
            }
            if (tag.m_128403_("PlayerID")) {
                this.setPlayerID(tag.m_128342_("PlayerID"));
            }
            if (tag.m_128441_("StitchPoints")) {
                this.setStitchPoints(tag.m_128469_("StitchPoints"));
            }
            this.maxAge = this.getTier() == 3 || this.getTier() == 4 ? Integer.MAX_VALUE : (2 + this.getCreatorLevel()) * 1200;
        }

        protected void m_7380_(CompoundTag tag) {
            tag.m_128405_("Age", this.age);
            tag.m_128359_("TargetDim", this.getTargetDimension());
            tag.m_128405_("CreatorLvl", this.getCreatorLevel());
            tag.m_128405_("Tier", this.getTier());
            tag.m_128405_("Stabilization", this.getStabilization());
            tag.m_128405_("RiftState", this.getRiftState());
            tag.m_128405_("StitchIndex", this.getStitchIndex());
            if (this.getPlayerID() != null) {
                tag.m_128362_("PlayerID", this.getPlayerID());
            }
            tag.m_128365_("StitchPoints", (Tag)this.getStitchPoints());
        }

        public Packet<ClientGamePacketListener> m_5654_() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }
    }
}

