/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.client.renderer;

import com.example.junctionmod.block.entity.StabilizerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class StabilizerRenderer
implements BlockEntityRenderer<StabilizerBlockEntity> {
    private static final ResourceLocation GUI_ICONS = new ResourceLocation("textures/gui/icons.png");

    public StabilizerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(StabilizerBlockEntity tile, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        int b;
        int g;
        int r;
        if (tile.getTargetRiftId() == -1 || tile.getAge() <= 0) {
            return;
        }
        Entity targetEntity = tile.m_58904_().m_6815_(tile.getTargetRiftId());
        if (targetEntity == null) {
            return;
        }
        poseStack.m_85836_();
        Vec3 start = new Vec3(0.5, 0.9, 0.5);
        double lerpX = Mth.m_14139_((double)partialTick, (double)targetEntity.f_19854_, (double)targetEntity.m_20185_());
        double lerpY = Mth.m_14139_((double)partialTick, (double)targetEntity.f_19855_, (double)targetEntity.m_20186_());
        double lerpZ = Mth.m_14139_((double)partialTick, (double)targetEntity.f_19856_, (double)targetEntity.m_20189_());
        Vec3 targetPos = new Vec3(lerpX, lerpY + (double)targetEntity.m_20206_() / 2.0, lerpZ);
        Vec3 end = targetPos.m_82492_((double)tile.m_58899_().m_123341_(), (double)tile.m_58899_().m_123342_(), (double)tile.m_58899_().m_123343_());
        VertexConsumer lineConsumer = buffer.m_6299_(RenderType.m_110504_());
        long gameTime = tile.m_58904_().m_46467_();
        int lightningCount = 1 + tile.getAge() / 40;
        for (int i = 0; i < lightningCount; ++i) {
            this.drawFractalLightning(poseStack, lineConsumer, start, end, gameTime + (long)(i * 1000));
        }
        poseStack.m_85849_();
        float progress = (float)tile.getAge() / (float)tile.getMaxAge();
        progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.3, 0.5);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        poseStack.m_85841_(-0.015f, -0.015f, 0.015f);
        VertexConsumer guiConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)GUI_ICONS));
        int barWidth = 100;
        int textureHeight = 5;
        float x = (float)(-barWidth) / 2.0f;
        float y = 0.0f;
        if (progress < 0.5f) {
            r = (int)(255.0f * (progress * 2.0f));
            g = 255;
            b = 0;
        } else {
            r = 255;
            g = (int)(255.0f * (1.0f - (progress - 0.5f) * 2.0f));
            b = 0;
        }
        if (progress > 0.95f && tile.m_58904_().m_46467_() % 4L < 2L) {
            r = 255;
            g = 255;
            b = 255;
        }
        int light = 0xF000F0;
        this.drawTexturedModalRect(poseStack, guiConsumer, x, y, 0.0f, 0, 64, barWidth, textureHeight, 255, 255, 255, 255, light);
        if (progress > 0.0f) {
            int filledWidth = (int)((float)barWidth * progress);
            this.drawTexturedModalRect(poseStack, guiConsumer, x, y, -0.02f, 0, 69, filledWidth, textureHeight, r, g, b, 255, light);
        }
        poseStack.m_85849_();
    }

    private void drawTexturedModalRect(PoseStack poseStack, VertexConsumer consumer, float x, float y, float z, int u, int v, int width, int height, int r, int g, int b, int a, int light) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float minU = (float)u * f;
        float maxU = (float)(u + width) * f;
        float minV = (float)v * f1;
        float maxV = (float)(v + height) * f1;
        consumer.m_252986_(pose, x, y + (float)height, z).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose, x + (float)width, y + (float)height, z).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose, x + (float)width, y, z).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose, x, y, z).m_6122_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private void drawTexturedModalRect(PoseStack poseStack, VertexConsumer consumer, float x, float y, float z, int u, int v, int width, int height, int r, int g, int b, int a) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float minU = (float)u * f;
        float maxU = (float)(u + width) * f;
        float minV = (float)v * f1;
        float maxV = (float)(v + height) * f1;
        int light = 0xF000F0;
        consumer.m_252986_(pose, x, y + (float)height, z).m_6122_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose, x + (float)width, y + (float)height, z).m_6122_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose, x + (float)width, y, z).m_6122_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(pose, x, y, z).m_6122_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private void drawFractalLightning(PoseStack poseStack, VertexConsumer consumer, Vec3 start, Vec3 end, long seed) {
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float nx = 0.0f;
        float ny = 1.0f;
        float nz = 0.0f;
        Random rand = new Random(seed);
        int segments = 8;
        Vec3 prevPos = start;
        Vec3 diff = end.m_82546_(start);
        for (int i = 1; i <= segments; ++i) {
            double t = (double)i / (double)segments;
            Vec3 currentBase = start.m_82549_(diff.m_82490_(t));
            double chaosFactor = Math.sin(t * Math.PI) * 0.4;
            Vec3 offset = new Vec3((rand.nextDouble() - 0.5) * chaosFactor, (rand.nextDouble() - 0.5) * chaosFactor, (rand.nextDouble() - 0.5) * chaosFactor);
            Vec3 currentPos = i == segments ? end : currentBase.m_82549_(offset);
            float thick = 0.02f;
            consumer.m_252986_(pose, (float)prevPos.f_82479_, (float)prevPos.f_82480_, (float)prevPos.f_82481_).m_6122_(0, 0, 0, 255).m_252939_(normal, nx, ny, nz).m_5752_();
            consumer.m_252986_(pose, (float)currentPos.f_82479_, (float)currentPos.f_82480_, (float)currentPos.f_82481_).m_6122_(0, 0, 0, 255).m_252939_(normal, nx, ny, nz).m_5752_();
            consumer.m_252986_(pose, (float)prevPos.f_82479_ + thick, (float)prevPos.f_82480_ + thick, (float)prevPos.f_82481_).m_6122_(0, 0, 0, 200).m_252939_(normal, nx, ny, nz).m_5752_();
            consumer.m_252986_(pose, (float)currentPos.f_82479_ + thick, (float)currentPos.f_82480_ + thick, (float)currentPos.f_82481_).m_6122_(0, 0, 0, 200).m_252939_(normal, nx, ny, nz).m_5752_();
            prevPos = currentPos;
        }
    }

    public boolean shouldRenderOffScreen(StabilizerBlockEntity pBlockEntity) {
        return true;
    }
}

