/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.client;

import com.example.junctionmod.capability.chunk.ChunkStability;
import com.example.junctionmod.capability.chunk.ClientboundChunkStabilityPacket;
import com.example.junctionmod.client.renderer.ChunkDebugRenderer;
import com.example.junctionmod.event.GlobalEventType;
import com.example.junctionmod.monolith.MonolithBlockEntity;
import com.example.junctionmod.monolith.MonolithSyncPacket;
import com.example.junctionmod.partikls.TeleportEffectPacket;
import com.example.junctionmod.tertserskill.TertserSkill;
import com.example.junctionmod.tertserskill.TertserSkillSyncPacket;
import com.example.junctionmod.vorial.ClientEventData;
import com.example.junctionmod.vorial.EventSyncPacket;
import com.example.junctionmod.vorial.VorialCapability;
import com.example.junctionmod.vorial.VorialSyncPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class ClientPayloadHandler {
    public static void handleVorialSync(VorialSyncPacket msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(VorialCapability.INSTANCE).ifPresent(cap -> {
                cap.setVorial(msg.getVorial());
                cap.setSuppressed(msg.isSuppressed());
            });
        }
    }

    public static void handleTeleportEffect(TeleportEffectPacket pkt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity entity = mc.f_91073_.m_6815_(pkt.getPlayerId());
        if (entity == null) {
            return;
        }
        double x = entity.m_20185_();
        double y = entity.m_20186_() + 1.0;
        double z = entity.m_20189_();
        if (pkt.isStartEffect()) {
            for (int i = 0; i < 50; ++i) {
                mc.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 0.0, 0.0, 0.0);
            }
        } else {
            mc.f_91073_.m_7785_(x, y, z, SoundEvents.f_11852_, SoundSource.PLAYERS, 0.8f, 1.0f, false);
        }
    }

    public static void handleChunkStability(ClientboundChunkStabilityPacket msg) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            LevelChunk chunk = Minecraft.m_91087_().f_91073_.m_6325_(msg.getChunkX(), msg.getChunkZ());
            chunk.getCapability(ChunkStability.INSTANCE).ifPresent(cap -> cap.setStability(msg.getStability()));
        }
    }

    public static void handleToggleDebug() {
        boolean bl = ChunkDebugRenderer.ENABLED = !ChunkDebugRenderer.ENABLED;
        if (Minecraft.m_91087_().f_91074_ != null) {
            String status = ChunkDebugRenderer.ENABLED ? "\u00a7a\u0412\u041a\u041b" : "\u00a7c\u0412\u042b\u041a\u041b";
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)("\u0414\u0435\u0431\u0430\u0433 \u0447\u0430\u043d\u043a\u043e\u0432: " + status)), true);
        }
    }

    public static void handleMonolithSync(MonolithSyncPacket msg) {
        BlockEntity be;
        if (Minecraft.m_91087_().f_91073_ != null && (be = Minecraft.m_91087_().f_91073_.m_7702_(msg.getPos())) instanceof MonolithBlockEntity) {
            MonolithBlockEntity monolith = (MonolithBlockEntity)be;
            monolith.setClientWhitelist(msg.getWhitelist());
        }
    }

    public static void handleTertserSkillSync(TertserSkillSyncPacket msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(TertserSkill.INSTANCE).ifPresent(cap -> {
                cap.setCurrentLevel(msg.getCurrentLevel());
                cap.setJumpsCount(msg.getJumpsCount());
                cap.setTotalJumpsCount(msg.getTotalJumpsCount());
                cap.setAnomaliesCount(msg.getAnomaliesCount());
                if (cap instanceof TertserSkill) {
                    TertserSkill impl = (TertserSkill)cap;
                    impl.setClientData(msg.getOwnedAnchors(), msg.getKnownAnchors(), msg.getKnownAnchorNames());
                }
            });
        }
    }

    public static void handleEventSync(EventSyncPacket msg) {
        ClientEventData.currentEvent = GlobalEventType.values()[msg.getEventOrdinal()];
    }
}

