/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.chat;

import com.example.junctionmod.chat.ChatDataObjects;
import com.example.junctionmod.chat.ChatFileManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="junctionmod")
public class ChatEvents {
    public static int LOCAL_RADIUS = 500;

    @SubscribeEvent
    public static void onChat(ServerChatEvent event) {
        String content;
        String channel;
        ServerPlayer sender = event.getPlayer();
        String msg = event.getRawText();
        ChatDataObjects.PlayerData data = ChatFileManager.getPlayerData(sender.m_20148_());
        if (msg.startsWith("!!")) {
            channel = "global";
            content = msg.substring(2).trim();
        } else if (msg.startsWith("!")) {
            channel = "dim";
            content = msg.substring(1).trim();
        } else {
            channel = "local";
            content = msg;
        }
        if (content.isEmpty()) {
            event.setCanceled(true);
            return;
        }
        if (ChatEvents.isMuted(data, "all") || ChatEvents.isMuted(data, channel)) {
            sender.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u0412\u044b \u0437\u0430\u0433\u043b\u0443\u0448\u0435\u043d\u044b \u0432 \u044d\u0442\u043e\u043c \u043a\u0430\u043d\u0430\u043b\u0435."));
            event.setCanceled(true);
            return;
        }
        ChatDataObjects.Prefix prefix = ChatFileManager.getPrefix(data.activePrefixId);
        MutableComponent prefixComp = Component.m_237119_();
        ChatFormatting nameColor = ChatFormatting.WHITE;
        if (prefix != null) {
            prefixComp = Component.m_237113_((String)(prefix.display + " "));
            try {
                nameColor = ChatFormatting.m_126657_((String)prefix.color);
                if (nameColor == null) {
                    nameColor = ChatFormatting.WHITE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String channelTag = switch (channel) {
            case "global" -> "\u00a75[\u041c\u0435\u0436\u043c\u0438\u0440\u043e\u0432\u043e\u0439] ";
            case "dim" -> "\u00a76[\u041c\u0438\u0440\u043e\u0432\u043e\u0439] ";
            default -> "\u00a77[\u041c\u0435\u0441\u0442\u043d\u044b\u0439] ";
        };
        ChatFormatting channelColor = ChatEvents.getChannelColor(channel);
        MutableComponent parsedContent = ChatEvents.parseMessageContent(sender, content, channelColor);
        MutableComponent finalMessage = Component.m_237113_((String)channelTag).m_7220_((Component)prefixComp).m_7220_((Component)Component.m_237113_((String)sender.m_7755_().getString()).m_130940_(nameColor)).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)parsedContent);
        event.setCanceled(true);
        sender.m_20194_().m_213846_((Component)Component.m_237113_((String)"[Chat Log] ").m_7220_((Component)finalMessage));
        for (ServerPlayer recipient : sender.m_20194_().m_6846_().m_11314_()) {
            String recipientName;
            String cleanContent;
            ChatDataObjects.PlayerData recData = ChatFileManager.getPlayerData(recipient.m_20148_());
            if (channel.equals("local") && !recData.listenLocal || channel.equals("dim") && !recData.listenDimension || channel.equals("global") && !recData.listenGlobal) continue;
            boolean shouldSend = false;
            if (channel.equals("global")) {
                shouldSend = true;
            } else if (channel.equals("dim")) {
                shouldSend = recipient.m_9236_().m_46472_() == sender.m_9236_().m_46472_();
            } else if (recipient.m_9236_().m_46472_() == sender.m_9236_().m_46472_()) {
                boolean bl = shouldSend = recipient.m_20280_((Entity)sender) <= (double)(LOCAL_RADIUS * LOCAL_RADIUS);
            }
            if (!shouldSend) continue;
            recipient.m_213846_((Component)finalMessage);
            if (recipient == sender || !(cleanContent = content.toLowerCase()).contains(recipientName = recipient.m_7755_().getString().toLowerCase()) && !cleanContent.contains("@" + recipientName)) continue;
            recipient.m_6330_((SoundEvent)SoundEvents.f_12210_.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
        }
    }

    private static MutableComponent parseMessageContent(ServerPlayer sender, String content, ChatFormatting defaultColor) {
        MutableComponent root = Component.m_237119_().m_130940_(defaultColor);
        String[] words = content.split(" ");
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (word.equalsIgnoreCase("[i]") || word.equalsIgnoreCase("[item]")) {
                ItemStack stack = sender.m_21205_();
                if (!stack.m_41619_()) {
                    MutableComponent itemComp = Component.m_237113_((String)"[").m_7220_(stack.m_41611_()).m_130946_("]");
                    itemComp.m_130938_(style -> style.m_131140_(stack.m_41791_().f_43022_).m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(stack))));
                    root.m_7220_((Component)itemComp);
                } else {
                    root.m_130946_(word);
                }
            } else {
                String rawName = word.startsWith("@") ? word.substring(1) : word;
                ServerPlayer mentionedPlayer = sender.m_20194_().m_6846_().m_11255_(rawName);
                if (mentionedPlayer != null) {
                    root.m_7220_((Component)Component.m_237113_((String)word).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
                } else {
                    root.m_130946_(word);
                }
            }
            if (i >= words.length - 1) continue;
            root.m_130946_(" ");
        }
        return root;
    }

    @SubscribeEvent
    public static void onNameFormat(PlayerEvent.NameFormat event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        ChatDataObjects.PlayerData data = ChatFileManager.getPlayerData(player.m_20148_());
        ChatDataObjects.Prefix prefix = ChatFileManager.getPrefix(data.activePrefixId);
        if (prefix != null) {
            event.setDisplayname((Component)Component.m_237113_((String)(prefix.display + " ")).m_7220_(event.getDisplayname()));
        }
    }

    @SubscribeEvent
    public static void onTabListNameFormat(PlayerEvent.TabListNameFormat event) {
        Player player = event.getEntity();
        ChatDataObjects.PlayerData data = ChatFileManager.getPlayerData(player.m_20148_());
        ChatDataObjects.Prefix prefix = ChatFileManager.getPrefix(data.activePrefixId);
        if (prefix != null) {
            event.setDisplayName((Component)Component.m_237113_((String)(prefix.display + " " + player.m_7755_().getString())));
        }
    }

    private static boolean isMuted(ChatDataObjects.PlayerData data, String type) {
        if (!data.activeMutes.containsKey(type)) {
            return false;
        }
        ChatDataObjects.MuteInfo info = data.activeMutes.get(type);
        if (System.currentTimeMillis() > info.expiry) {
            data.activeMutes.remove(type);
            return false;
        }
        return true;
    }

    private static ChatFormatting getChannelColor(String channel) {
        return switch (channel) {
            case "global" -> ChatFormatting.LIGHT_PURPLE;
            case "dim" -> ChatFormatting.GOLD;
            default -> ChatFormatting.GRAY;
        };
    }
}

