/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.capability.chunk;

import com.example.junctionmod.client.ClientPayloadHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundChunkStabilityPacket {
    private final int chunkX;
    private final int chunkZ;
    private final float stability;

    public ClientboundChunkStabilityPacket(int x, int z, float stability) {
        this.chunkX = x;
        this.chunkZ = z;
        this.stability = stability;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public float getStability() {
        return this.stability;
    }

    public static void encode(ClientboundChunkStabilityPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.chunkX);
        buf.writeInt(msg.chunkZ);
        buf.writeFloat(msg.stability);
    }

    public static ClientboundChunkStabilityPacket decode(FriendlyByteBuf buf) {
        return new ClientboundChunkStabilityPacket(buf.readInt(), buf.readInt(), buf.readFloat());
    }

    public static void handle(ClientboundChunkStabilityPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPayloadHandler.handleChunkStability(msg)));
        ctx.get().setPacketHandled(true);
    }
}

