/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.capability.chunk;

import com.example.junctionmod.ModRegistry;
import com.example.junctionmod.capability.chunk.ChunkStability;
import com.example.junctionmod.capability.chunk.ChunkStabilityProvider;
import com.example.junctionmod.capability.chunk.ClientboundChunkStabilityPacket;
import com.example.junctionmod.capability.chunk.IChunkStability;
import com.example.junctionmod.vorial.VorialNetwork;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="junctionmod")
public class ChunkStabilityHandler {
    public static final ResourceLocation CAP_ID = new ResourceLocation("junctionmod", "chunk_stability");
    private static final float REGEN_BASE_5SEC = 0.008333f;
    private static final float REGEN_FAST_5SEC = 0.025f;
    private static final float REGEN_ATERCENITE_5SEC = 0.004166f;

    @SubscribeEvent
    public static void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(IChunkStability.class);
    }

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<LevelChunk> event) {
        if (!((LevelChunk)event.getObject()).getCapability(ChunkStability.INSTANCE).isPresent()) {
            event.addCapability(CAP_ID, (ICapabilityProvider)new ChunkStabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.level.f_46443_) {
            return;
        }
        if (event.level.m_46467_() % 100L != 0L) {
            return;
        }
        ServerLevel level = (ServerLevel)event.level;
        long time = level.m_46467_();
        HashSet<Long> processedChunks = new HashSet<Long>();
        for (ServerPlayer player : level.m_6907_()) {
            ChunkPos playerPos = player.m_146902_();
            int radius = 8;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    LevelChunk chunk;
                    int cx = playerPos.f_45578_ + x;
                    int cz = playerPos.f_45579_ + z;
                    long chunkKey = ChunkPos.m_45589_((int)cx, (int)cz);
                    if (processedChunks.contains(chunkKey) || (chunk = level.m_7726_().m_7131_(cx, cz)) == null) continue;
                    ChunkStabilityHandler.processChunk(level, chunk, time, true);
                    processedChunks.add(chunkKey);
                }
            }
        }
    }

    private static void processChunk(ServerLevel level, LevelChunk chunk, long time, boolean playerNearby) {
        chunk.getCapability(ChunkStability.INSTANCE).ifPresent(cap -> {
            float oldStability;
            if (playerNearby) {
                cap.setLastPlayerTime(time);
            }
            float currentRegen = 0.008333f;
            if (time - cap.getLastPlayerTime() > 6000L) {
                currentRegen = 0.025f;
            }
            if (cap.getAterceniteCount() > 0) {
                currentRegen += (float)cap.getAterceniteCount() * 0.004166f;
            }
            if ((oldStability = cap.getStability()) < 100.0f) {
                cap.addStability(currentRegen);
                if (Math.abs(cap.getStability() - oldStability) > 0.01f) {
                    ChunkStabilityHandler.sendSyncPacket(level, chunk.m_7697_(), cap.getStability());
                }
            }
        });
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (!event.getLevel().m_5776_() && event.getState().m_60734_() == ModRegistry.ATERCENITE_BLOCK.get()) {
            LevelChunk chunk = (LevelChunk)event.getLevel().m_46865_(event.getPos());
            chunk.getCapability(ChunkStability.INSTANCE).ifPresent(cap -> cap.changeAterceniteCount(1));
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getLevel().m_5776_() && event.getState().m_60734_() == ModRegistry.ATERCENITE_BLOCK.get()) {
            LevelChunk chunk = (LevelChunk)event.getLevel().m_46865_(event.getPos());
            chunk.getCapability(ChunkStability.INSTANCE).ifPresent(cap -> cap.changeAterceniteCount(-1));
        }
    }

    public static void sendSyncPacket(ServerLevel level, ChunkPos pos, float stability) {
        VorialNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_6325_(pos.f_45578_, pos.f_45579_)), (Object)new ClientboundChunkStabilityPacket(pos.f_45578_, pos.f_45579_, stability));
    }
}

