/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.anchor;

import com.example.junctionmod.ModRegistry;
import com.example.junctionmod.anchor.SpatialAnchorMenu;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SpatialAnchorBlockEntity
extends BlockEntity
implements MenuProvider {
    private UUID ownerUUID;
    private String ownerName = "Unknown";
    private String anchorName = "\u041f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u042f\u043a\u043e\u0440\u044c";
    private final Map<UUID, String> knownUsers = new HashMap<UUID, String>();
    private final Set<UUID> bannedUsers = new HashSet<UUID>();
    private boolean isActive = true;

    public SpatialAnchorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.SPATIAL_ANCHOR_BE.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)this.anchorName);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new SpatialAnchorMenu(id, inv, this);
    }

    public void setOwner(UUID uuid, String name) {
        this.ownerUUID = uuid;
        this.ownerName = name;
        this.m_6596_();
    }

    public boolean isOwner(Player player) {
        return this.ownerUUID != null && this.ownerUUID.equals(player.m_20148_());
    }

    public void setAnchorName(String name) {
        this.anchorName = name.length() > 32 ? name.substring(0, 32) : name;
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public void registerUser(Player player) {
        if (!this.knownUsers.containsKey(player.m_20148_())) {
            this.knownUsers.put(player.m_20148_(), player.m_7755_().getString());
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public void toggleBan(UUID uuid) {
        if (this.bannedUsers.contains(uuid)) {
            this.bannedUsers.remove(uuid);
        } else {
            this.bannedUsers.add(uuid);
        }
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isBanned(UUID uuid) {
        return this.bannedUsers.contains(uuid);
    }

    public void setActive(boolean active) {
        this.isActive = active;
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Map<UUID, String> getKnownUsers() {
        return this.knownUsers;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        tag.m_128359_("OwnerName", this.ownerName);
        tag.m_128379_("IsActive", this.isActive);
        tag.m_128359_("AnchorName", this.anchorName);
        ListTag userList = new ListTag();
        this.knownUsers.forEach((uuid, name) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("ID", uuid);
            entry.m_128359_("Name", name);
            userList.add((Object)entry);
        });
        tag.m_128365_("Users", (Tag)userList);
        ListTag banList = new ListTag();
        for (UUID uuid2 : this.bannedUsers) {
            banList.add((Object)StringTag.m_129297_((String)uuid2.toString()));
        }
        tag.m_128365_("Banned", (Tag)banList);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        this.ownerName = tag.m_128461_("OwnerName");
        this.isActive = tag.m_128471_("IsActive");
        this.anchorName = tag.m_128441_("AnchorName") ? tag.m_128461_("AnchorName") : "\u041f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u042f\u043a\u043e\u0440\u044c";
        this.knownUsers.clear();
        if (tag.m_128441_("Users")) {
            ListTag userList = tag.m_128437_("Users", 10);
            for (int i = 0; i < userList.size(); ++i) {
                CompoundTag entry = userList.m_128728_(i);
                this.knownUsers.put(entry.m_128342_("ID"), entry.m_128461_("Name"));
            }
        }
        this.bannedUsers.clear();
        if (tag.m_128441_("Banned")) {
            ListTag banList = tag.m_128437_("Banned", 8);
            for (Tag t : banList) {
                this.bannedUsers.add(UUID.fromString(t.m_7916_()));
            }
        }
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

