/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.anchor;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class AnchorManager {
    private static final Map<ResourceKey<Level>, Set<BlockPos>> anchors = new ConcurrentHashMap<ResourceKey<Level>, Set<BlockPos>>();

    public static void addAnchor(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        anchors.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> ConcurrentHashMap.newKeySet()).add(pos.m_7949_());
    }

    public static void removeAnchor(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        Set<BlockPos> dimAnchors = anchors.get(level.m_46472_());
        if (dimAnchors != null) {
            dimAnchors.remove(pos);
        }
    }

    public static boolean isTooClose(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return false;
        }
        Set<BlockPos> dimAnchors = anchors.get(level.m_46472_());
        if (dimAnchors == null || dimAnchors.isEmpty()) {
            return false;
        }
        int minDistSq = 10000;
        for (BlockPos anchorPos : dimAnchors) {
            if (anchorPos.equals((Object)pos) || !(pos.m_123331_((Vec3i)anchorPos) < (double)minDistSq)) continue;
            return true;
        }
        return false;
    }

    public static void clear() {
        anchors.clear();
    }
}

