/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.anchor;

import com.example.junctionmod.anchor.SpatialAnchorBlockEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class AnchorActionPacket {
    private final BlockPos pos;
    private final Action action;
    private final UUID targetUuid;

    public AnchorActionPacket(BlockPos pos, Action action, UUID targetUuid) {
        this.pos = pos;
        this.action = action;
        this.targetUuid = targetUuid;
    }

    public static void encode(AnchorActionPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.m_130068_((Enum)msg.action);
        buf.writeBoolean(msg.targetUuid != null);
        if (msg.targetUuid != null) {
            buf.m_130077_(msg.targetUuid);
        }
    }

    public static AnchorActionPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        Action action = (Action)buf.m_130066_(Action.class);
        UUID uuid = buf.readBoolean() ? buf.m_130259_() : null;
        return new AnchorActionPacket(pos, action, uuid);
    }

    public static void handle(AnchorActionPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            if (!level.m_46749_(msg.pos)) {
                return;
            }
            BlockEntity be = level.m_7702_(msg.pos);
            if (be instanceof SpatialAnchorBlockEntity) {
                SpatialAnchorBlockEntity anchor = (SpatialAnchorBlockEntity)be;
                if (!anchor.isOwner((Player)player)) {
                    return;
                }
                switch (msg.action) {
                    case TOGGLE_ACTIVE: {
                        anchor.setActive(!anchor.isActive());
                        break;
                    }
                    case TOGGLE_BAN: {
                        if (msg.targetUuid == null) break;
                        anchor.toggleBan(msg.targetUuid);
                    }
                }
                level.m_7726_().m_8450_(msg.pos);
                anchor.m_6596_();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Action {
        TOGGLE_ACTIVE,
        TOGGLE_BAN;

    }
}

