/*
 * Decompiled with CFR 0.152.
 */
package com.example.junctionmod.Atercenite;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class AterceniteManager {
    public static final int FIELD_RADIUS = 40;
    public static final int FIELD_RADIUS_SQR = 1600;
    private static final Map<ResourceKey<Level>, Map<ChunkPos, Set<BlockPos>>> placedByChunk = new ConcurrentHashMap<ResourceKey<Level>, Map<ChunkPos, Set<BlockPos>>>();

    public static void addBlock(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        ResourceKey dim = level.m_46472_();
        ChunkPos chunkPos = new ChunkPos(pos);
        Map dimMap = placedByChunk.computeIfAbsent((ResourceKey<Level>)dim, k -> new ConcurrentHashMap());
        Set chunkBlocks = dimMap.computeIfAbsent(chunkPos, k -> ConcurrentHashMap.newKeySet());
        chunkBlocks.add(pos.m_7949_());
    }

    public static void removeBlock(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        ResourceKey dim = level.m_46472_();
        ChunkPos chunkPos = new ChunkPos(pos);
        Map<ChunkPos, Set<BlockPos>> dimMap = placedByChunk.get(dim);
        if (dimMap != null) {
            Set<BlockPos> chunkBlocks = dimMap.get(chunkPos);
            if (chunkBlocks != null) {
                chunkBlocks.remove(pos);
                if (chunkBlocks.isEmpty()) {
                    dimMap.remove(chunkPos);
                }
            }
            if (dimMap.isEmpty()) {
                placedByChunk.remove(dim);
            }
        }
    }

    public static boolean isPlayerInField(ServerPlayer player) {
        return AterceniteManager.isLocationInField(player.m_9236_(), player.m_20183_());
    }

    public static boolean isLocationInField(Level level, BlockPos pos) {
        ResourceKey dim = level.m_46472_();
        Map<ChunkPos, Set<BlockPos>> dimMap = placedByChunk.get(dim);
        if (dimMap == null || dimMap.isEmpty()) {
            return false;
        }
        ChunkPos originChunk = new ChunkPos(pos);
        int radiusChunks = 3;
        for (int x = -radiusChunks; x <= radiusChunks; ++x) {
            for (int z = -radiusChunks; z <= radiusChunks; ++z) {
                ChunkPos checkPos = new ChunkPos(originChunk.f_45578_ + x, originChunk.f_45579_ + z);
                Set<BlockPos> blocksInChunk = dimMap.get(checkPos);
                if (blocksInChunk == null) continue;
                for (BlockPos blockPos : blocksInChunk) {
                    if (!(pos.m_123331_((Vec3i)blockPos) <= 1600.0)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void onChunkUnload(Level level, ChunkPos chunkPos) {
        if (level.m_5776_()) {
            return;
        }
        ResourceKey dim = level.m_46472_();
        Map<ChunkPos, Set<BlockPos>> dimMap = placedByChunk.get(dim);
        if (dimMap != null) {
            dimMap.remove(chunkPos);
        }
    }

    public static void clear() {
        placedByChunk.clear();
    }
}

