/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.inventoryessentials.PlatformBindings;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventoryUtils {
    public static boolean isSameInventory(Slot targetSlot, Slot slot) {
        return InventoryUtils.isSameInventory(targetSlot, slot, false);
    }

    public static boolean isSameInventory(Slot targetSlot, Slot slot, boolean treatHotBarAsSeparate) {
        boolean isHotBar;
        boolean isTargetPlayerInventory = targetSlot.f_40218_ instanceof Inventory;
        boolean isTargetHotBar = isTargetPlayerInventory && Inventory.m_36045_((int)targetSlot.m_150661_());
        boolean isPlayerInventory = slot.f_40218_ instanceof Inventory;
        boolean bl = isHotBar = isPlayerInventory && Inventory.m_36045_((int)slot.m_150661_());
        if (isTargetPlayerInventory && isPlayerInventory && treatHotBarAsSeparate) {
            return isHotBar == isTargetHotBar;
        }
        return PlatformBindings.INSTANCE.isSameInventory(targetSlot, slot);
    }

    public static boolean containerContainsPlayerInventory(AbstractContainerMenu menu) {
        for (Slot slot : menu.f_38839_) {
            if (!(slot.f_40218_ instanceof Inventory) || slot.m_150661_() < 9 || slot.m_150661_() >= 37) continue;
            return true;
        }
        return false;
    }

    public static Map<EquipmentSlot, Slot> findMatchingArmorSetSlots(AbstractContainerMenu menu, Slot baseSlot) {
        HashMap<EquipmentSlot, Slot> result = new HashMap<EquipmentSlot, Slot>();
        List<EquipmentSlot> equipmentSlots = Arrays.stream(EquipmentSlot.values()).filter(EquipmentSlot::m_254934_).toList();
        ItemStack baseItem = baseSlot.m_7993_();
        Item item = baseItem.m_41720_();
        if (item instanceof Equipable) {
            Equipable equipable = (Equipable)item;
            result.put(equipable.m_40402_(), baseSlot);
        }
        for (Slot slot : menu.f_38839_) {
            Equipable equipable;
            if (menu instanceof InventoryMenu && slot.f_40219_ >= 5 && slot.f_40219_ < 9) continue;
            ItemStack slotStack = slot.m_7993_();
            Item item2 = slotStack.m_41720_();
            if (item2 instanceof Equipable && (equipable = (Equipable)item2).m_40402_().m_254934_() && InventoryUtils.isMatchingArmorSet(baseItem, slotStack) && !result.containsKey(equipable.m_40402_())) {
                result.put(equipable.m_40402_(), slot);
            }
            if (result.size() < equipmentSlots.size()) continue;
            break;
        }
        return result;
    }

    private static boolean isMatchingArmorSet(ItemStack baseItem, ItemStack otherItem) {
        Item item = baseItem.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem baseArmorItem = (ArmorItem)item;
            item = otherItem.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem otherArmorItem = (ArmorItem)item;
                return baseArmorItem.m_40401_() == otherArmorItem.m_40401_();
            }
        }
        return false;
    }
}

