/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionRegistry;
import de.keksuccino.fancymenu.customization.action.Executable;
import de.keksuccino.fancymenu.customization.action.ValuePlaceholderHolder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionInstance
implements Executable,
ValuePlaceholderHolder {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    public volatile Action action;
    @Nullable
    public volatile String value;
    @NotNull
    protected final Map<String, Supplier<String>> valuePlaceholders = new HashMap<String, Supplier<String>>();
    @NotNull
    public String identifier = ScreenCustomization.generateUniqueIdentifier();

    public ActionInstance(@NotNull Action action, @Nullable String value) {
        this.action = Objects.requireNonNull(action);
        this.value = value;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void execute() {
        String v = this.value;
        try {
            if (!this.action.checkAsync()) {
                return;
            }
            if (v != null) {
                for (Map.Entry<String, Supplier<String>> m : this.valuePlaceholders.entrySet()) {
                    String replaceWith = m.getValue().get();
                    if (replaceWith == null) {
                        replaceWith = "";
                    }
                    v = v.replace("$$" + m.getKey(), replaceWith);
                }
                v = PlaceholderParser.replacePlaceholders(v);
            }
            this.action.currentInstance = this;
            if (this.action.hasValue()) {
                this.action.execute(v);
            } else {
                this.action.execute(null);
            }
        }
        catch (Exception ex) {
            LOGGER.error("################################");
            LOGGER.error("[FANCYMENU] An error occurred while trying to execute an action!");
            LOGGER.error("[FANCYMENU] Action: " + this.action.getIdentifier());
            LOGGER.error("[FANCYMENU] Value Raw: " + this.value);
            LOGGER.error("[FANCYMENU] Value: " + v);
            LOGGER.error("################################", (Throwable)ex);
        }
    }

    @Override
    public void addValuePlaceholder(@NotNull String placeholder, @NotNull Supplier<String> replaceWithSupplier) {
        if (!CharacterFilter.buildResourceNameFilter().isAllowedText(placeholder)) {
            throw new RuntimeException("Illegal characters used in placeholder name! Use only [a-z], [0-9], [_], [-]!");
        }
        this.valuePlaceholders.put(placeholder, replaceWithSupplier);
    }

    @Override
    @NotNull
    public Map<String, Supplier<String>> getValuePlaceholders() {
        return this.valuePlaceholders;
    }

    @Override
    @NotNull
    public ActionInstance copy(boolean unique) {
        ActionInstance i = new ActionInstance(this.action, this.value);
        if (!unique) {
            i.identifier = this.identifier;
        }
        i.valuePlaceholders.putAll(this.valuePlaceholders);
        return i;
    }

    @Override
    @NotNull
    public PropertyContainer serialize() {
        PropertyContainer c = new PropertyContainer("executable_action_instance");
        String key = "[executable_action_instance:" + this.identifier + "][action_type:" + this.action.getIdentifier() + "]";
        String val = this.value;
        c.putProperty(key, val != null ? val : "");
        return c;
    }

    @NotNull
    public static List<ActionInstance> deserializeAll(@NotNull PropertyContainer serialized) {
        List<ActionInstance> instances = new ArrayList<ActionInstance>();
        for (Map.Entry<String, String> m : serialized.getProperties().entrySet()) {
            String actionType;
            if (m.getKey().equals("buttonaction")) {
                instances = ActionInstance.deserializeLegacyButtonActions(serialized);
                break;
            }
            if (m.getKey().startsWith("tickeraction_")) {
                instances = ActionInstance.deserializeLegacyTickerActions(serialized);
                break;
            }
            if (!m.getKey().startsWith("[executable_action_instance:") || !m.getKey().contains("]")) continue;
            String identifier = m.getKey().split("\\[executable_action_instance:", 2)[1].split("]", 2)[0];
            if (!m.getKey().contains("[action_type:") || !(actionType = m.getKey().split("\\[action_type:", 2)[1]).contains("]")) continue;
            Action action = ActionRegistry.getAction(actionType = actionType.split("]", 2)[0]);
            if (action != null) {
                ActionInstance i = new ActionInstance(action, action.hasValue() ? m.getValue() : null);
                i.identifier = identifier;
                instances.add(i);
                continue;
            }
            LOGGER.error("[FANCYMENU] Action type not found! Registry returned NULL for type: " + actionType, (Throwable)new NullPointerException("Action type not registered"));
        }
        return instances;
    }

    @NotNull
    protected static List<ActionInstance> deserializeLegacyButtonActions(@NotNull PropertyContainer serialized) {
        ArrayList<ActionInstance> instances = new ArrayList<ActionInstance>();
        String buttonAction = serialized.getValue("buttonaction");
        String actionValue = serialized.getValue("value");
        if (actionValue == null) {
            actionValue = "";
        }
        if (buttonAction != null) {
            if (buttonAction.contains("%btnaction_splitter_fm%")) {
                for (String s : StringUtils.splitLines((String)buttonAction, (String)"%btnaction_splitter_fm%")) {
                    Action a;
                    if (s.length() <= 0) continue;
                    String actionIdentifier = s;
                    String value = null;
                    if (s.contains(";")) {
                        actionIdentifier = s.split(";", 2)[0];
                        value = s.split(";", 2)[1];
                    }
                    if ((a = ActionRegistry.getAction(actionIdentifier)) == null) continue;
                    instances.add(new ActionInstance(a, value));
                }
            } else {
                Action a = ActionRegistry.getAction(buttonAction);
                if (a != null) {
                    instances.add(new ActionInstance(a, actionValue));
                }
            }
        }
        return instances;
    }

    @NotNull
    protected static List<ActionInstance> deserializeLegacyTickerActions(@NotNull PropertyContainer serialized) {
        ArrayList<ActionInstance> instances = new ArrayList<ActionInstance>();
        HashMap<Integer, ActionInstance> tempActions = new HashMap<Integer, ActionInstance>();
        for (Map.Entry<String, String> m : serialized.getProperties().entrySet()) {
            Action a;
            if (!m.getKey().startsWith("tickeraction_")) continue;
            String index = m.getKey().split("_", 3)[1];
            String tickerAction = m.getKey().split("_", 3)[2];
            String actionValue = m.getValue();
            if (!MathUtils.isInteger((String)index) || (a = ActionRegistry.getAction(tickerAction)) == null) continue;
            tempActions.put(Integer.parseInt(index), new ActionInstance(a, actionValue));
        }
        ArrayList indexes = new ArrayList(tempActions.keySet());
        Collections.sort(indexes);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            instances.add((ActionInstance)tempActions.get(i));
        }
        return instances;
    }
}

