/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.entity.PhotographEntity;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.NotNull;

public class PhotographEntityRenderer<T extends PhotographEntity>
extends EntityRenderer<T> {
    public PhotographEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T pEntity) {
        return InventoryMenu.f_39692_;
    }

    public boolean shouldRender(T livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return super.m_5523_(livingEntity, camera, camX, camY, camZ);
    }

    public void render(@NotNull T entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(entity.m_146909_()));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entity.m_146908_()));
        poseStack.m_252781_(Axis.f_252403_.m_252977_((float)((PhotographEntity)((Object)entity)).getRotation() * 360.0f / 4.0f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85837_(-0.5, -0.5, 0.02625);
        float scale = 1.0f / (float)ExposureClient.getExposureRenderer().getSize();
        poseStack.m_85841_(scale, scale, -scale);
        boolean isGlowing = ((PhotographEntity)((Object)entity)).isGlowing();
        if (isGlowing) {
            packedLight = 0xF000F0;
        }
        int brightness = isGlowing ? 255 : this.getPhotographBrightness(entity);
        ItemStack item = ((PhotographEntity)((Object)entity)).getItem();
        PhotographRenderer.render(item, !entity.m_20145_(), true, poseStack, bufferSource, packedLight, brightness, brightness, brightness, 255);
        poseStack.m_85849_();
    }

    public int getPhotographBrightness(T entity) {
        if (entity.m_6350_() == Direction.UP) {
            return 255;
        }
        int lightLevel = entity.m_9236_().m_45517_(LightLayer.BLOCK, entity.m_20183_());
        float shadeFactor = entity.m_9236_().m_7717_(entity.m_6350_(), true);
        shadeFactor += (1.0f - shadeFactor) * 0.05f;
        int shadedBrightness = (int)(255.0f * shadeFactor);
        int missingLight = 255 - shadedBrightness;
        int lightUp = (int)((float)missingLight * ((float)lightLevel / 15.0f * 0.7f));
        return Math.min(255, shadedBrightness + lightUp);
    }
}

