/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.camera.capture.converter.DitheringColorConverter;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.CreateChromaticExposureS2CP;
import io.github.mortuusars.exposure.network.packet.client.WaitForExposureChangeS2CP;
import io.github.mortuusars.exposure.render.image.ExposureDataImage;
import io.github.mortuusars.exposure.render.image.IImage;
import io.github.mortuusars.exposure.util.ColorChannel;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChromaticSheetItem
extends Item {
    public static final String EXPOSURES_TAG = "Exposures";

    public ChromaticSheetItem(Item.Properties properties) {
        super(properties);
    }

    public List<CompoundTag> getExposures(ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128425_(EXPOSURES_TAG, 9)) {
            return Collections.emptyList();
        }
        ListTag channelsList = stack.m_41783_().m_128437_(EXPOSURES_TAG, 10);
        return channelsList.stream().map(t -> (CompoundTag)t).collect(Collectors.toList());
    }

    public void addExposure(ItemStack stack, CompoundTag frame) {
        ListTag channelsList = this.getOrCreateExposuresTag(stack);
        channelsList.add((Object)frame);
        stack.m_41784_().m_128365_(EXPOSURES_TAG, (Tag)channelsList);
    }

    private ListTag getOrCreateExposuresTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        ListTag list = tag.m_128437_(EXPOSURES_TAG, 10);
        tag.m_128365_(EXPOSURES_TAG, (Tag)list);
        return list;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        List<CompoundTag> exposures = this.getExposures(stack);
        if (!exposures.isEmpty()) {
            MutableComponent component = Component.m_237115_((String)"gui.exposure.channel.red").m_130948_(Style.f_131099_.m_178520_(ColorChannel.RED.getRepresentationColor()));
            if (exposures.size() >= 2) {
                component.m_7220_((Component)Component.m_237115_((String)"gui.exposure.channel.separator").m_130940_(ChatFormatting.GRAY));
                component.m_7220_((Component)Component.m_237115_((String)"gui.exposure.channel.green").m_130948_(Style.f_131099_.m_178520_(ColorChannel.GREEN.getRepresentationColor())));
            }
            if (exposures.size() >= 3) {
                component.m_7220_((Component)Component.m_237115_((String)"gui.exposure.channel.separator").m_130940_(ChatFormatting.GRAY));
                component.m_7220_((Component)Component.m_237115_((String)"gui.exposure.channel.blue").m_130948_(Style.f_131099_.m_178520_(ColorChannel.BLUE.getRepresentationColor())));
            }
            tooltipComponents.add((Component)component);
            if (exposures.size() >= 3) {
                tooltipComponents.add((Component)Component.m_237115_((String)"item.exposure.chromatic_sheet.use_tooltip").m_130940_(ChatFormatting.GRAY));
            } else {
                tooltipComponents.add((Component)Component.m_237115_((String)"item.exposure.chromatic_sheet.info").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (stack.m_41783_() != null && stack.m_41783_().m_128471_("RequiresDeferredFinalization")) {
                ItemStack finalizedItem = this.finalize(level, stack, player.m_6302_(), player);
                player.m_150109_().m_6836_(slotId, finalizedItem);
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!level.f_46443_ && this.getExposures(stack).size() >= 3) {
            ServerPlayer serverPlayer;
            ItemStack result = this.finalize(level, stack, player.m_6302_(), player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null);
            player.m_21008_(usedHand, result);
            return InteractionResultHolder.m_19090_((Object)result);
        }
        return super.m_7203_(level, player, usedHand);
    }

    public ItemStack finalize(@NotNull Level level, ItemStack stack, String idPrefix, @Nullable ServerPlayer player) {
        Preconditions.checkState((!level.f_46443_ ? 1 : 0) != 0, (Object)"Can only finalize server-side.");
        List<CompoundTag> exposures = this.getExposures(stack);
        Preconditions.checkState((exposures.size() >= 3 ? 1 : 0) != 0, (Object)("Finalizing Chromatic Fragment requires 3 exposures. " + String.valueOf(stack)));
        CompoundTag redFrame = exposures.get(0);
        CompoundTag greenFrame = exposures.get(1);
        CompoundTag blueFrame = exposures.get(2);
        String exposureId = ChromaticSheetItem.getChromaticExposureId(level, idPrefix);
        ItemStack photograph = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
        CompoundTag tag = redFrame.m_6426_();
        tag = tag.m_128391_(greenFrame);
        tag = tag.m_128391_(blueFrame);
        tag.m_128473_("ChromaticChannel");
        tag.m_128359_("Id", exposureId);
        tag.m_128379_("Chromatic", true);
        tag.m_128359_("RedChannel", this.getFrameName(redFrame));
        tag.m_128359_("GreenChannel", this.getFrameName(greenFrame));
        tag.m_128359_("BlueChannel", this.getFrameName(blueFrame));
        tag.m_128359_("Type", FilmType.COLOR.m_7912_());
        photograph.m_41751_(tag);
        boolean hasTexture = this.hasTextureFrame(redFrame, greenFrame, blueFrame);
        if (!hasTexture) {
            return this.finalizeServerside(stack, photograph, level, exposureId, redFrame, greenFrame, blueFrame);
        }
        if (player != null) {
            Packets.sendToClient(new CreateChromaticExposureS2CP(redFrame, greenFrame, blueFrame, exposureId), player);
            return photograph;
        }
        stack.m_41784_().m_128379_("RequiresDeferredFinalization", true);
        return stack;
    }

    @NotNull
    private static String getChromaticExposureId(@NotNull Level level, String idPrefix) {
        return String.format("%s_chromatic_%s", idPrefix, level.m_46467_());
    }

    protected String getFrameName(CompoundTag frame) {
        if (frame.m_128441_("Id")) {
            return frame.m_128461_("Id");
        }
        if (frame.m_128441_("Texture")) {
            return frame.m_128461_("Texture");
        }
        return "unknown";
    }

    protected boolean hasTextureFrame(CompoundTag red, CompoundTag green, CompoundTag blue) {
        if (!red.m_128441_("Id") && red.m_128441_("Texture")) {
            return true;
        }
        if (!green.m_128441_("Id") && green.m_128441_("Texture")) {
            return true;
        }
        return !blue.m_128441_("Id") && blue.m_128441_("Texture");
    }

    protected ItemStack finalizeServerside(ItemStack chromaticSheetStack, ItemStack photographStack, @NotNull Level level, String exposureId, CompoundTag redFrame, CompoundTag greenFrame, CompoundTag blueFrame) {
        @Nullable IImage redImage = this.getExposureImage(redFrame);
        if (redImage == null) {
            Exposure.LOGGER.error("Cannot create Chromatic Photograph: Red channel image is not found in frame {}.", (Object)redFrame);
            return chromaticSheetStack;
        }
        @Nullable IImage greenImage = this.getExposureImage(greenFrame);
        if (greenImage == null) {
            Exposure.LOGGER.error("Cannot create Chromatic Photograph: Green channel image is not found in frame {}.", (Object)greenFrame);
            return chromaticSheetStack;
        }
        @Nullable IImage blueImage = this.getExposureImage(blueFrame);
        if (blueImage == null) {
            Exposure.LOGGER.error("Cannot create Chromatic Photograph: Blue channel image is not found in frame {}.", (Object)blueFrame);
            return chromaticSheetStack;
        }
        Packets.sendToAllClients(new WaitForExposureChangeS2CP(exposureId));
        new Thread(() -> {
            try {
                this.processAndSaveTrichrome(redImage, greenImage, blueImage, exposureId);
            }
            catch (Exception e) {
                Exposure.LOGGER.error("Cannot process and save Chromatic Photograph: {}", (Object)e.toString());
            }
        }).start();
        return photographStack;
    }

    @Nullable
    protected IImage getExposureImage(CompoundTag frame) {
        if (frame.m_128425_("Id", 8)) {
            String exposureId = frame.m_128461_("Id");
            return ExposureServer.getExposureStorage().getOrQuery(exposureId).map(data -> new ExposureDataImage(exposureId, (ExposureSavedData)((Object)data))).orElse(null);
        }
        return null;
    }

    protected boolean processAndSaveTrichrome(IImage red, IImage green, IImage blue, String id) {
        int width = Math.min(red.getWidth(), Math.min(green.getWidth(), blue.getWidth()));
        int height = Math.min(red.getHeight(), Math.min(green.getHeight(), blue.getHeight()));
        if (width <= 0 || height <= 0) {
            Exposure.LOGGER.error("Cannot create Chromatic Photograph: Width and Height should be larger than 0. Width '{}', Height: '{}'.", (Object)width, (Object)height);
            return false;
        }
        int[][] pixels = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int abgr;
                int a = FastColor.ABGR32.m_266503_((int)red.getPixelABGR(x, y));
                int b = FastColor.ABGR32.m_266247_((int)blue.getPixelABGR(x, y));
                int g = FastColor.ABGR32.m_266446_((int)green.getPixelABGR(x, y));
                int r = FastColor.ABGR32.m_266313_((int)red.getPixelABGR(x, y));
                pixels[y][x] = abgr = FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b);
            }
        }
        byte[] mapColorPixels = new DitheringColorConverter().convert(pixels);
        CompoundTag properties = new CompoundTag();
        properties.m_128359_("Type", FilmType.COLOR.m_7912_());
        long unixTime = System.currentTimeMillis() / 1000L;
        properties.m_128356_("Timestamp", unixTime);
        ExposureSavedData resultData = new ExposureSavedData(width, height, mapColorPixels, properties);
        ExposureServer.getExposureStorage().put(id, resultData);
        ExposureServer.getExposureStorage().sendExposureChanged(id);
        return true;
    }
}

