/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.menu.ItemRenameMenu;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemRenameScreen
extends AbstractContainerScreen<ItemRenameMenu> {
    public static final ResourceLocation TEXTURE = Exposure.resource("textures/gui/item_rename.png");
    private EditBox name;

    public ItemRenameScreen(ItemRenameMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void m_7856_() {
        this.f_97726_ = 206;
        this.f_97727_ = 66;
        this.f_97730_ = -999;
        this.f_97731_ = -999;
        this.f_97728_ = 28;
        super.m_7856_();
        this.name = new EditBox(this.f_96547_, this.f_97735_ + 32, this.f_97736_ + 21, 142, 12, (Component)Component.m_237115_((String)"gui.exposure.item_rename.title"));
        this.name.m_94202_(-1);
        this.name.m_94205_(-1);
        this.name.m_94182_(false);
        this.name.m_94199_(50);
        this.name.m_94151_(this::onNameChanged);
        this.name.m_94144_(((ItemRenameMenu)this.m_6262_()).getItemName());
        this.m_7787_((GuiEventListener)this.name);
        this.m_264313_((GuiEventListener)this.name);
        ImageButton applyButton = new ImageButton(this.f_97735_ + 133, this.f_97736_ + 42, 19, 19, this.f_97726_, 0, 19, TEXTURE, 256, 256, button -> this.confirm(), (Component)Component.m_237115_((String)"gui.exposure.item_rename.apply"));
        applyButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure.item_rename.apply")));
        this.m_142416_((GuiEventListener)applyButton);
        ImageButton cancelButton = new ImageButton(this.f_97735_ + 154, this.f_97736_ + 42, 19, 19, this.f_97726_ + 19, 0, 19, TEXTURE, 256, 256, button -> this.cancel(), (Component)Component.m_237115_((String)"gui.exposure.item_rename.cancel"));
        cancelButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.exposure.item_rename.cancel")));
        this.m_142416_((GuiEventListener)cancelButton);
    }

    private void confirm() {
        ((ItemRenameMenu)this.m_6262_()).m_6366_((Player)Minecraft.m_91087_().f_91074_, 0);
        Objects.requireNonNull(Minecraft.m_91087_().f_91072_).m_105208_(((ItemRenameMenu)this.m_6262_()).f_38840_, 0);
        this.m_7379_();
    }

    private void cancel() {
        this.m_7379_();
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String string = this.name.m_94155_();
        this.m_6575_(minecraft, width, height);
        this.name.m_94144_(string);
    }

    public void m_181908_() {
        super.m_181908_();
        this.name.m_94120_();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.name.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        super.m_280072_(guiGraphics, x, y);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    private void onNameChanged(String name) {
        ItemStack itemStack = ((ItemRenameMenu)this.m_6262_()).m_38853_(0).m_7993_();
        if (!itemStack.m_41788_() && name.equals(itemStack.m_41786_().getString())) {
            name = "";
        }
        if (((ItemRenameMenu)this.m_6262_()).setItemName(name) && Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.f_108617_.m_104955_((Packet)new ServerboundRenameItemPacket(name));
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
        }
        if (keyCode != 258 && (this.name.m_7933_(keyCode, scanCode, modifiers) || this.name.m_94204_())) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1 && this.name.m_5953_(mouseX, mouseY)) {
            this.name.m_94144_("");
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

