/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.infrastructure;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.data.Lenses;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FocalRange
implements StringRepresentable {
    public static final int ALLOWED_MIN = 10;
    public static final int ALLOWED_MAX = 300;
    private final int min;
    private final int max;

    public FocalRange(int min, int max) {
        Preconditions.checkArgument((10 <= min && min <= 300 ? 1 : 0) != 0, (Object)(min + " is not in allowed range for 'min'."));
        Preconditions.checkArgument((10 <= max && max <= 300 ? 1 : 0) != 0, (Object)(max + " is not in allowed range for 'max'."));
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)("'min' should not be larger than 'max'. min: " + min + ", max: " + max));
        this.min = min;
        this.max = max;
    }

    public FocalRange(int fixedValue) {
        Preconditions.checkArgument((10 <= fixedValue && fixedValue <= 300 ? 1 : 0) != 0, (Object)(fixedValue + " is not in allowed range: 10-300"));
        this.min = fixedValue;
        this.max = fixedValue;
    }

    public static FocalRange fromNetwork(FriendlyByteBuf buffer) {
        int min = buffer.readInt();
        int max = buffer.readInt();
        return new FocalRange(min, max);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeInt(this.min);
        buffer.writeInt(this.max);
    }

    public boolean isPrime() {
        return this.min == this.max;
    }

    public static FocalRange ofStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return FocalRange.getDefault();
        }
        if (!stack.m_204117_(Exposure.Tags.Items.LENSES)) {
            Exposure.LOGGER.error(String.valueOf(stack) + " is not a valid lens. Should have '#exposure:lenses' tag.");
            return FocalRange.getDefault();
        }
        return Lenses.getFocalRangeOf(stack).orElse(FocalRange.getDefault());
    }

    @NotNull
    public static FocalRange getDefault() {
        return FocalRange.parse((String)Config.Common.CAMERA_DEFAULT_FOCAL_RANGE.get());
    }

    @NotNull
    public String m_7912_() {
        return this.isPrime() ? Integer.toString(this.min) : this.min + "-" + this.max;
    }

    public static FocalRange parse(String value) {
        int dashIndex = value.indexOf("-");
        if (dashIndex == -1) {
            int prime = Integer.parseInt(value);
            return new FocalRange(prime);
        }
        int min = Integer.parseInt(value.substring(0, dashIndex));
        int max = Integer.parseInt(value.substring(dashIndex + 1));
        return new FocalRange(min, max);
    }

    public static FocalRange fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (json.isJsonPrimitive()) {
            int fixedValue = json.getAsInt();
            return new FocalRange(fixedValue);
        }
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            int min = obj.get("min").getAsInt();
            int max = obj.get("max").getAsInt();
            return new FocalRange(min, max);
        }
        throw new JsonSyntaxException("Invalid FocalRange json. Expected a number or json object with 'min' and 'max'.");
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FocalRange that = (FocalRange)obj;
        return this.min == that.min && this.max == that.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        if (this.isPrime()) {
            return "FocalRange[fixed=" + this.min + "]";
        }
        return "FocalRange[min=" + this.min + ", max=" + this.max + "]";
    }
}

