/*
 * Decompiled with CFR 0.152.
 */
package com.worldswanderer.ethercondenser;

import com.worldswanderer.ethercondenser.EtherCondenserMenu;
import com.worldswanderer.ethercondenser.EtherCondenserMod;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class EtherCondenserBlockEntity
extends BlockEntity
implements WorldlyContainer,
MenuProvider {
    final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            EtherCondenserBlockEntity.this.m_6596_();
        }
    };
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    private final Map<Direction, LazyOptional<IItemHandler>> sidedHandlers = new EnumMap<Direction, LazyOptional<IItemHandler>>(Direction.class);
    private int conversionTimer = 0;
    private static final int CONVERSION_TIME = 12000;
    public int progress = 0;
    private static final String REQUIRED_DIMENSION = "aether:the_aether";
    private static final int MAX_CHUNK_LOAD = 5;
    private static final Map<Long, Set<EtherCondenserBlockEntity>> CHUNKS_LOAD = new ConcurrentHashMap<Long, Set<EtherCondenserBlockEntity>>();

    private int getConversionTime() {
        return 12000 * Math.max(this.getChunkLoadPercent(), 100) / 100;
    }

    public EtherCondenserBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EtherCondenserMod.ETHER_CONDENSER_BLOCK_ENTITY.get(), pos, state);
    }

    public void tick(Level level, BlockPos pos) {
        boolean wasWorking;
        if (level.m_5776_()) {
            return;
        }
        if (!level.m_46472_().m_135782_().toString().equals(REQUIRED_DIMENSION)) {
            this.progress = 0;
            this.conversionTimer = 0;
            return;
        }
        boolean bl = wasWorking = this.progress > 0;
        if (this.canProcess()) {
            ++this.conversionTimer;
            this.progress = this.conversionTimer * 100 / this.getConversionTime();
            if (this.conversionTimer >= this.getConversionTime()) {
                this.convertItems();
                this.conversionTimer = 0;
                this.progress = 0;
            }
            long chunkKey = (long)(pos.m_123341_() >> 4) & 0xFFFFFFFFL | ((long)(pos.m_123343_() >> 4) & 0xFFFFFFFFL) << 32;
            CHUNKS_LOAD.computeIfAbsent(chunkKey, k -> ConcurrentHashMap.newKeySet()).add(this);
        } else {
            this.conversionTimer = 0;
            this.progress = 0;
            long chunkKey = (long)(pos.m_123341_() >> 4) & 0xFFFFFFFFL | ((long)(pos.m_123343_() >> 4) & 0xFFFFFFFFL) << 32;
            Set<EtherCondenserBlockEntity> loaders = CHUNKS_LOAD.get(chunkKey);
            if (loaders != null) {
                loaders.remove((Object)this);
                if (loaders.isEmpty()) {
                    CHUNKS_LOAD.remove(chunkKey);
                }
            }
        }
        if (wasWorking != this.progress > 0) {
            this.m_6596_();
        }
        if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
            this.pushItemsOut(level, pos);
        }
    }

    private boolean canProcess() {
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        ItemStack outputStack = this.itemHandler.getStackInSlot(1);
        ItemStack etherCrystal = new ItemStack((ItemLike)EtherCondenserMod.ETHER_CRYSTAL.get());
        return inputStack.m_150930_(Items.f_42692_) && !inputStack.m_41619_() && (outputStack.m_41619_() || outputStack.m_150930_(etherCrystal.m_41720_()) && outputStack.m_41613_() < outputStack.m_41741_());
    }

    private void convertItems() {
        ItemStack inputStack = this.itemHandler.getStackInSlot(0);
        ItemStack outputStack = this.itemHandler.getStackInSlot(1);
        ItemStack etherCrystal = new ItemStack((ItemLike)EtherCondenserMod.ETHER_CRYSTAL.get());
        inputStack.m_41774_(1);
        if (outputStack.m_41619_()) {
            this.itemHandler.setStackInSlot(1, etherCrystal.m_41777_());
        } else {
            outputStack.m_41769_(1);
        }
        this.m_6596_();
    }

    private void pushItemsOut(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        Direction direction = Direction.DOWN;
        BlockPos targetPos = pos.m_121945_(direction);
        BlockEntity targetEntity = level.m_7702_(targetPos);
        if (targetEntity != null) {
            targetEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).ifPresent(targetHandler -> {
                ItemStack remainder;
                ItemStack outputStack = this.itemHandler.extractItem(1, 1, false);
                if (!outputStack.m_41619_() && !(remainder = targetHandler.insertItem(0, outputStack, false)).m_41619_()) {
                    this.itemHandler.insertItem(1, outputStack, false);
                }
            });
        }
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public boolean m_7155_(int slot, ItemStack item, @Nullable Direction direction) {
        if (slot == 0 && direction != Direction.DOWN) {
            return item.m_150930_(Items.f_42692_);
        }
        return false;
    }

    public boolean m_7157_(int slot, ItemStack item, Direction direction) {
        return slot == 1 && direction == Direction.DOWN;
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        return this.itemHandler.getStackInSlot(0).m_41619_() && this.itemHandler.getStackInSlot(1).m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.itemHandler.extractItem(slot, amount, false);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
        this.m_6596_();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.conversionTimer = tag.m_128451_("conversionTimer");
        this.progress = tag.m_128451_("progress");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("conversionTimer", this.conversionTimer);
        tag.m_128405_("progress", this.progress);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.sidedHandlers.computeIfAbsent(side, d -> LazyOptional.of(() -> new SidedInvWrapper((WorldlyContainer)this, d))).cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        for (LazyOptional<IItemHandler> opt : this.sidedHandlers.values()) {
            opt.invalidate();
        }
        this.sidedHandlers.clear();
    }

    public void ejectItems() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
        }
    }

    public int getChunkLoadPercent() {
        if (this.f_58857_ == null) {
            return 0;
        }
        int chunkX = this.f_58858_.m_123341_() >> 4;
        int chunkZ = this.f_58858_.m_123343_() >> 4;
        return CHUNKS_LOAD.getOrDefault((long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32, Set.of()).size() * 100 / 5;
    }

    public void m_7651_() {
        super.m_7651_();
        long chunkKey = (long)(this.f_58858_.m_123341_() >> 4) & 0xFFFFFFFFL | ((long)(this.f_58858_.m_123343_() >> 4) & 0xFFFFFFFFL) << 32;
        Set<EtherCondenserBlockEntity> loaders = CHUNKS_LOAD.get(chunkKey);
        if (loaders != null) {
            loaders.remove((Object)this);
            if (loaders.isEmpty()) {
                CHUNKS_LOAD.remove(chunkKey);
            }
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.ethercondenser.ether_condenser");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new EtherCondenserMenu(containerId, inventory, this);
    }
}

