/*
 * Decompiled with CFR 0.152.
 */
package cc.abbie.emi_ores.compat.emi.recipe;

import cc.abbie.emi_ores.EmiOres;
import cc.abbie.emi_ores.compat.emi.EmiOresRecipeCategories;
import cc.abbie.emi_ores.compat.emi.recipe.AbstractPlacedFeatureEmiRecipe;
import cc.abbie.emi_ores.compat.emi.stack.BiomeEmiStack;
import cc.abbie.emi_ores.mixin.accessor.HeightRangePlacementAccessor;
import cc.abbie.emi_ores.mixin.accessor.NoiseProviderAccessor;
import cc.abbie.emi_ores.mixin.accessor.RarityFilterAccessor;
import cc.abbie.emi_ores.mixin.accessor.SimpleStateProviderAccessor;
import cc.abbie.emi_ores.mixin.accessor.WeightedStateProviderAccessor;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class GeodeGenEmiRecipe
extends AbstractPlacedFeatureEmiRecipe {
    private final HeightProvider heightProvider;
    private final int rarityChance;
    private final EmiIngredient biomes;
    private final EmiIngredient alternateInner;
    private final EmiIngredient inner;
    private final EmiIngredient middle;
    private final EmiIngredient outer;
    private final EmiIngredient filling;
    private final EmiIngredient innerPlacements;
    private final ResourceLocation id;

    public GeodeGenEmiRecipe(PlacedFeature feature, ResourceLocation id) {
        this.id = id;
        HeightProvider heightProvider = null;
        int rarityChance = -1;
        List<Object> biomes = List.of();
        for (PlacementModifier modifier : feature.f_191776_()) {
            if (modifier instanceof HeightRangePlacement) {
                HeightRangePlacement heightRangePlacement = (HeightRangePlacement)modifier;
                heightProvider = ((HeightRangePlacementAccessor)heightRangePlacement).getHeight();
                continue;
            }
            if (modifier instanceof RarityFilter) {
                RarityFilter rarityFilter = (RarityFilter)modifier;
                rarityChance = ((RarityFilterAccessor)rarityFilter).getChance();
                continue;
            }
            if (!(modifier instanceof BiomeFilter)) continue;
            biomes = GeodeGenEmiRecipe.getBiomes(id, feature);
        }
        this.heightProvider = heightProvider;
        this.rarityChance = rarityChance;
        this.biomes = EmiIngredient.of(biomes.stream().map(BiomeEmiStack::of).collect(Collectors.toList()));
        GeodeConfiguration config = (GeodeConfiguration)((ConfiguredFeature)feature.f_191775_().m_203334_()).f_65378_();
        GeodeBlockSettings blockSettings = config.f_160813_;
        GeodeLayerSettings layerSettings = config.f_160814_;
        this.alternateInner = GeodeGenEmiRecipe.ingredientForStateProvider(blockSettings.f_158289_).setChance((float)config.f_160817_);
        this.filling = GeodeGenEmiRecipe.ingredientForStateProvider(blockSettings.f_158287_).setAmount((long)Math.ceil(layerSettings.f_158342_));
        this.inner = GeodeGenEmiRecipe.ingredientForStateProvider(blockSettings.f_158288_).setAmount((long)Math.ceil(layerSettings.f_158343_ - layerSettings.f_158342_));
        this.middle = GeodeGenEmiRecipe.ingredientForStateProvider(blockSettings.f_158290_).setAmount((long)Math.ceil(layerSettings.f_158344_ - layerSettings.f_158343_));
        this.outer = GeodeGenEmiRecipe.ingredientForStateProvider(blockSettings.f_158291_).setAmount((long)Math.ceil(layerSettings.f_158345_ - layerSettings.f_158344_));
        this.innerPlacements = EmiIngredient.of(blockSettings.f_158292_.stream().map(BlockBehaviour.BlockStateBase::m_60734_).map(EmiStack::of).collect(Collectors.toList())).setChance((float)config.f_160816_);
    }

    private static EmiIngredient ingredientForStateProvider(BlockStateProvider provider) {
        if (provider instanceof SimpleStateProvider) {
            SimpleStateProvider simple = (SimpleStateProvider)provider;
            return EmiStack.of((ItemLike)((SimpleStateProviderAccessor)simple).getState().m_60734_());
        }
        if (provider instanceof WeightedStateProvider) {
            WeightedStateProvider weighted = (WeightedStateProvider)provider;
            return EmiIngredient.of(((WeightedStateProviderAccessor)weighted).getWeightedList().m_146338_().stream().map(WeightedEntry.Wrapper::m_146310_).map(BlockBehaviour.BlockStateBase::m_60734_).map(EmiStack::of).toList());
        }
        if (provider instanceof NoiseProvider) {
            NoiseProvider noise = (NoiseProvider)provider;
            return EmiIngredient.of(((NoiseProviderAccessor)noise).getStates().stream().map(BlockBehaviour.BlockStateBase::m_60734_).distinct().map(EmiStack::of).toList());
        }
        return EmiStack.EMPTY;
    }

    public EmiRecipeCategory getCategory() {
        return EmiOresRecipeCategories.GEODE;
    }

    public ResourceLocation getId() {
        return EmiOres.id("/geode/" + this.id.m_135827_() + "/" + this.id.m_135815_());
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.biomes);
    }

    public List<EmiStack> getOutputs() {
        return Stream.of(this.innerPlacements, this.filling, this.alternateInner, this.inner, this.middle, this.outer).map(EmiIngredient::getEmiStacks).flatMap(Collection::stream).toList();
    }

    public int getDisplayWidth() {
        return 160;
    }

    public int getDisplayHeight() {
        return 90;
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public void addWidgets(WidgetHolder widgets) {
        Component veinFreq;
        widgets.addSlot(this.filling, 0, 18).recipeContext((EmiRecipe)this);
        widgets.addSlot(this.innerPlacements, 46, 18).recipeContext((EmiRecipe)this);
        widgets.addSlot(this.inner, 0, 36).recipeContext((EmiRecipe)this);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 20, 36);
        widgets.addSlot(this.alternateInner, 46, 36).recipeContext((EmiRecipe)this);
        widgets.addSlot(this.middle, 0, 54).recipeContext((EmiRecipe)this);
        widgets.addSlot(this.outer, 0, 72).recipeContext((EmiRecipe)this);
        GeodeGenEmiRecipe.addDistributionGraph(widgets, 64, 0, this.heightProvider);
        if (!this.biomes.isEmpty()) {
            widgets.addSlot(this.biomes, 96, 18);
        }
        if ((veinFreq = GeodeGenEmiRecipe.getVeinFreqComponent(-1, -1, this.rarityChance)) != null) {
            widgets.addText(veinFreq, 160, 45, 0, false).horizontalAlign(TextWidget.Alignment.END).verticalAlign(TextWidget.Alignment.CENTER);
        }
    }
}

