/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.color;

import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class FastCubicSampler {
    private static final double[] DENSITY_CURVE = new double[]{0.0, 1.0, 4.0, 6.0, 4.0, 1.0, 0.0};
    private static final int DIAMETER = 6;

    public static Vec3 sampleColor(Vec3 pos, ColorFetcher colorFetcher, Function<Vec3, Vec3> transformer) {
        int intX = Mth.m_14107_((double)pos.m_7096_());
        int intY = Mth.m_14107_((double)pos.m_7098_());
        int intZ = Mth.m_14107_((double)pos.m_7094_());
        int[] values = new int[216];
        for (int x = 0; x < 6; ++x) {
            int blockX = intX - 2 + x;
            for (int y = 0; y < 6; ++y) {
                int blockY = intY - 2 + y;
                for (int z = 0; z < 6; ++z) {
                    int blockZ = intZ - 2 + z;
                    values[FastCubicSampler.index((int)x, (int)y, (int)z)] = colorFetcher.fetch(blockX, blockY, blockZ);
                }
            }
        }
        if (FastCubicSampler.isHomogenousArray(values)) {
            return transformer.apply(Vec3.m_82501_((int)values[0]));
        }
        double deltaX = pos.m_7096_() - (double)intX;
        double deltaY = pos.m_7098_() - (double)intY;
        double deltaZ = pos.m_7094_() - (double)intZ;
        Vec3 sum = Vec3.f_82478_;
        double totalFactor = 0.0;
        for (int x = 0; x < 6; ++x) {
            double densityX = Mth.m_14139_((double)deltaX, (double)DENSITY_CURVE[x + 1], (double)DENSITY_CURVE[x]);
            for (int y = 0; y < 6; ++y) {
                double densityY = Mth.m_14139_((double)deltaY, (double)DENSITY_CURVE[y + 1], (double)DENSITY_CURVE[y]);
                for (int z = 0; z < 6; ++z) {
                    double densityZ = Mth.m_14139_((double)deltaZ, (double)DENSITY_CURVE[z + 1], (double)DENSITY_CURVE[z]);
                    double factor = densityX * densityY * densityZ;
                    totalFactor += factor;
                    Vec3 color = transformer.apply(Vec3.m_82501_((int)values[FastCubicSampler.index(x, y, z)]));
                    sum = sum.m_82549_(color.m_82490_(factor));
                }
            }
        }
        sum = sum.m_82490_(1.0 / totalFactor);
        return sum;
    }

    private static int index(int x, int y, int z) {
        return 36 * z + 6 * y + x;
    }

    private static boolean isHomogenousArray(int[] arr) {
        int val = arr[0];
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] == val) continue;
            return false;
        }
        return true;
    }

    public static interface ColorFetcher {
        public int fetch(int var1, int var2, int var3);
    }
}

