/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.dimensionfixer.world;

import com.github.mahmudindev.mcmod.dimensionfixer.DimensionFixer;
import com.github.mahmudindev.mcmod.dimensionfixer.config.Config;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionAliasData;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionTweakData;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionManager {
    private static final Map<ResourceLocation, DimensionAliasData> ALIASES = new HashMap<ResourceLocation, DimensionAliasData>();
    private static final Map<ResourceLocation, DimensionTweakData> TWEAKS = new HashMap<ResourceLocation, DimensionTweakData>();

    public static void onResourceManagerReload(ResourceManager manager) {
        ALIASES.clear();
        TWEAKS.clear();
        Config config = Config.getConfig();
        config.getAliases().forEach((dimension, alias) -> DimensionManager.setAlias(new ResourceLocation(dimension), alias));
        config.getTweaks().forEach((dimension, tweak) -> DimensionManager.setTweak(new ResourceLocation(dimension), tweak));
        Gson gson = new Gson();
        manager.m_214160_("dimensionfixer", resourceLocation -> resourceLocation.m_135815_().endsWith(".json")).forEach((resourceLocation, resources) -> resources.forEach(resource -> {
            String resourcePath = resourceLocation.m_135815_().replaceFirst("^%s/".formatted("dimensionfixer"), "");
            try {
                String dimensionPath = resourcePath.substring(resourcePath.indexOf("/") + 1).replaceAll("\\.json$", "");
                if (resourcePath.startsWith("alias/")) {
                    DimensionManager.setAlias(resourceLocation.m_247449_(dimensionPath), (DimensionAliasData)gson.fromJson(JsonParser.parseReader((Reader)resource.m_215508_()), DimensionAliasData.class));
                } else if (resourcePath.startsWith("tweak/")) {
                    DimensionManager.setTweak(resourceLocation.m_247449_(dimensionPath), (DimensionTweakData)gson.fromJson(JsonParser.parseReader((Reader)resource.m_215508_()), DimensionTweakData.class));
                }
            }
            catch (IOException e) {
                DimensionFixer.LOGGER.error("Failed to read datapack", (Throwable)e);
            }
        }));
    }

    public static Map<ResourceLocation, DimensionAliasData> getAliases() {
        return Map.copyOf(ALIASES);
    }

    public static DimensionAliasData getAlias(ResourceLocation dimension) {
        return ALIASES.get(dimension);
    }

    public static void setAlias(ResourceLocation dimension, DimensionAliasData alias) {
        if (!ALIASES.containsKey(dimension)) {
            ALIASES.put(dimension, new DimensionAliasData());
        }
        DimensionAliasData aliasX = DimensionManager.getAlias(dimension);
        aliasX.addAllDimensionType(alias.getDimensionTypes());
        aliasX.addAllDimension(alias.getDimensions());
    }

    public static boolean isAliasDimension(Level dimensionA, ResourceKey<Level> dimensionB) {
        DimensionAliasData alias = DimensionManager.getAlias(dimensionB.m_135782_());
        if (alias != null) {
            if (alias.containDimensionType((ResourceKey<DimensionType>)dimensionA.m_220362_())) {
                return true;
            }
            return alias.containDimension((ResourceKey<Level>)dimensionA.m_46472_());
        }
        return false;
    }

    public static DimensionTweakData getTweak(ResourceKey<Level> dimension) {
        return TWEAKS.get(dimension.m_135782_());
    }

    public static void setTweak(ResourceLocation dimension, DimensionTweakData tweak) {
        TWEAKS.put(dimension, tweak);
    }
}

