/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.dimensionfixer.config;

import com.github.mahmudindev.mcmod.dimensionfixer.DimensionFixer;
import com.github.mahmudindev.mcmod.dimensionfixer.DimensionFixerExpectPlatform;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionAliasData;
import com.github.mahmudindev.mcmod.dimensionfixer.world.DimensionTweakData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;

public class Config {
    private static final Path CONFIG_DIR = DimensionFixerExpectPlatform.getConfigDir();
    private static Config CONFIG = new Config();
    private final Map<String, DimensionAliasData> aliases = new HashMap<String, DimensionAliasData>();
    private final Map<String, DimensionTweakData> tweaks = new HashMap<String, DimensionTweakData>();

    private void defaults() {
        DimensionAliasData alias0 = new DimensionAliasData();
        alias0.addDimensionType((ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223538_);
        alias0.addDimensionType((ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223541_);
        this.aliases.put(String.valueOf(Level.f_46428_.m_135782_()), alias0);
        DimensionAliasData alias1 = new DimensionAliasData();
        alias1.addDimensionType((ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223539_);
        this.aliases.put(String.valueOf(Level.f_46429_.m_135782_()), alias1);
        DimensionAliasData alias2 = new DimensionAliasData();
        alias2.addDimensionType((ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223540_);
        this.aliases.put(String.valueOf(Level.f_46430_.m_135782_()), alias2);
        DimensionTweakData tweak0 = new DimensionTweakData();
        tweak0.setFixSleeping(true);
        tweak0.setFixPortalSearchRadius(true);
        tweak0.setOverrideFlatCheck(true);
        this.tweaks.put("dimensionfixer:dimension", tweak0);
    }

    public Map<String, DimensionAliasData> getAliases() {
        return this.aliases;
    }

    public Map<String, DimensionTweakData> getTweaks() {
        return this.tweaks;
    }

    public static void load() {
        Gson parser = new GsonBuilder().setPrettyPrinting().create();
        File configFile = CONFIG_DIR.resolve("dimensionfixer.json").toFile();
        if (!configFile.exists()) {
            CONFIG.defaults();
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write(parser.toJson((Object)CONFIG));
            }
            catch (IOException e) {
                DimensionFixer.LOGGER.error("Failed to write config", (Throwable)e);
            }
        } else {
            try (FileReader reader = new FileReader(configFile);){
                CONFIG = (Config)parser.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                DimensionFixer.LOGGER.error("Failed to read config", (Throwable)e);
            }
        }
    }

    public static Config getConfig() {
        return CONFIG;
    }
}

