/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbridge;

import com.google.common.collect.ImmutableList;
import com.hlysine.create_connected.ConnectedLang;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import net.createmod.catnip.lang.LangNumberFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

public class StressImpactScrollValueBehaviour
extends ScrollValueBehaviour {
    public StressImpactScrollValueBehaviour(Component label, SmartBlockEntity be, ValueBoxTransform slot) {
        super(label, be, slot);
        this.withFormatter(v -> String.format("%1sx", LangNumberFormat.format((double)StressImpactScrollValueBehaviour.convertValue(v))));
    }

    public static float convertValue(int value) {
        if (value < 40) {
            return (float)Math.pow(2.0, Math.abs((double)value / 10.0));
        }
        return (int)Math.pow(2.0, Math.abs((double)value / 10.0));
    }

    public ValueSettingsBoard createBoard(Player player, BlockHitResult hitResult) {
        ImmutableList rows = ImmutableList.of((Object)ConnectedLang.translateDirect("kinetic_bridge.stress_impact_short", new Object[0]));
        ValueSettingsFormatter formatter = new ValueSettingsFormatter(this::formatSettings);
        return new ValueSettingsBoard(this.label, 160, 10, (List)rows, formatter);
    }

    public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
        int value = Math.max(0, valueSetting.value());
        if (!valueSetting.equals((Object)this.getValueSettings())) {
            this.playFeedbackSound((BlockEntityBehaviour)this);
        }
        this.setValue(Mth.m_14040_((int)value));
    }

    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(0, Math.abs(this.value));
    }

    public MutableComponent formatSettings(ValueSettingsBehaviour.ValueSettings settings) {
        return ConnectedLang.number(Math.max(0.0f, StressImpactScrollValueBehaviour.convertValue(settings.value()))).add(Component.m_237113_((String)"x")).component();
    }

    public String getClipboardKey() {
        return "Stress Impact";
    }
}

