/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.compat;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public enum Mods {
    JEI("jei"),
    COPYCATS("copycats"),
    DIAGONAL_FENCES("diagonalfences"),
    DREAMS_DESIRES("create_dd"),
    NUCLEAR("createnuclear"),
    HENRY("create_henry"),
    ADDITIONAL_PLACEMENTS("additionalplacements"),
    GARNISHED("garnished"),
    DRAGONS_PLUS("create_dragons_plus"),
    STEAM_N_RAILS("railways");

    private final String id;

    private Mods(String id) {
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public ResourceLocation rl(String path) {
        return new ResourceLocation(this.id, path);
    }

    public Item getItem(String id) {
        return (Item)ForgeRegistries.ITEMS.getValue(this.rl(id));
    }

    public Item getItem(ResourceLocation id) {
        return (Item)ForgeRegistries.ITEMS.getValue(id);
    }

    public Ingredient getIngredient(final String id) {
        return new Ingredient(Stream.of(new Ingredient.Value(){

            @NotNull
            public Collection<ItemStack> m_6223_() {
                return List.of();
            }

            @NotNull
            public JsonObject m_6544_() {
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("item", Mods.this.rl(id).toString());
                return jsonobject;
            }
        }));
    }

    public boolean isLoaded() {
        return ModList.get().isLoaded(this.id);
    }

    public <T> Optional<T> runIfInstalled(Supplier<Supplier<T>> toRun) {
        if (this.isLoaded()) {
            return Optional.of(toRun.get().get());
        }
        return Optional.empty();
    }

    public void executeIfInstalled(Supplier<Runnable> toExecute) {
        if (this.isLoaded()) {
            toExecute.get().run();
        }
    }
}

