/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.summon;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LivingCandleEntity
extends CompanionSummonEntity {
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");

    public LivingCandleEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new MoveControl((Mob)this);
        this.f_19797_ = this.m_217043_().m_188503_(6);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    @Override
    @Nullable
    public LivingEntity m_269323_() {
        return this.m_21805_() == null ? null : (LivingEntity)CompanionsEntityTracker.getEntityByUUID(this.m_21805_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FollowOwnerGoal((TamableAnimal)this, 0.6, 2.0f, 50.0f, false));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!(this.m_9236_().f_46443_ || this.m_21824_() && this.m_269323_() != null)) {
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            this.findNearestSoulMage(serverLevel);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 3) {
            this.spawnDeadParticles();
        } else {
            super.m_7822_(pId);
        }
    }

    private void spawnDeadParticles() {
        for (int i = 0; i < 15; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 2.0 * 0.2;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 2.0 * 0.2;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 2.0 * 0.2;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), dx * 1.05, dy * 1.05, dz * 1.05);
            if (i % 5 != 0) continue;
            this.m_9236_().m_7106_((ParticleOptions)CompanionsParticles.GOLDEN_ALLAY_TRAIL.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), dx, dy, dz);
        }
    }

    public void doKill() {
        if (this.m_9236_().f_46443_) {
            this.spawnDeadParticles();
        } else {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11897_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
        this.m_146870_();
    }

    private void findNearestSoulMage(ServerLevel serverLevel) {
        List nearbyMages = serverLevel.m_6443_(SoulMageEntity.class, this.m_20191_().m_82400_(20.0), EntitySelector.f_20408_);
        if (!nearbyMages.isEmpty()) {
            SoulMageEntity closestMage = (SoulMageEntity)((Object)nearbyMages.get(0));
            double closestDistance = this.m_20280_((Entity)closestMage);
            for (int i = 1; i < nearbyMages.size(); ++i) {
                SoulMageEntity mage = (SoulMageEntity)((Object)nearbyMages.get(i));
                double distance = this.m_20280_((Entity)mage);
                if (!(distance < closestDistance)) continue;
                closestMage = mage;
                closestDistance = distance;
            }
            if (closestMage.getCandleCount() < 6) {
                this.m_21816_(closestMage.m_20148_());
                closestMage.setCandleCount(closestMage.getCandleCount() + 1);
                closestMage.candles.add(this);
                this.m_7105_(true);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

