/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HealRingProjectile
extends BaseProjectile
implements GeoEntity {
    private final RawAnimation HEAL = RawAnimation.begin().thenPlay("heal");
    private boolean hasHealed = false;

    public HealRingProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
        this.f_19811_ = true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Entity owner = this.m_19749_();
        if (owner == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (owner != null && !owner.m_213877_() && owner instanceof LivingEntity) {
            if (this.f_19797_ % 10 == 0 && !this.hasHealed) {
                for (LivingEntity e : this.m_9236_().m_45976_(LivingEntity.class, owner.m_20191_().m_82400_(2.0))) {
                    if (e.m_21222_()) {
                        e.m_6469_(this.m_269291_().m_269425_(), (float)CompanionsConfig.HEAL_RING_HEALING);
                        this.spawnParticles((Entity)e, CompanionsParticles.SHADE_SUMMON.get());
                        continue;
                    }
                    e.m_5634_((float)CompanionsConfig.HEAL_RING_HEALING);
                    this.spawnParticles((Entity)e, (SimpleParticleType)KnightLibParticles.STARSET.get());
                }
                this.hasHealed = true;
            }
            Vec3 targetPos = new Vec3(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
            Vec3 offset = targetPos.m_82546_(this.m_20182_());
            Vec3 velocity = this.m_20184_();
            double K = 0.6;
            double C = 2.0 * Math.sqrt(K);
            Vec3 accel = offset.m_82490_(K).m_82546_(velocity.m_82490_(C));
            velocity = velocity.m_82549_(accel);
            this.m_20256_(velocity);
            this.m_6478_(MoverType.SELF, velocity);
        }
    }

    private void spawnParticles(Entity e, SimpleParticleType p) {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.f_46441_.m_188501_() < 0.45f) {
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, e.m_20185_(), e.m_20186_() + 0.15, e.m_20189_(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.f_46441_.m_188501_() < 0.55f)) continue;
            level2.m_8767_((ParticleOptions)p, e.m_20185_(), e.m_20186_() + 0.15, e.m_20189_(), 1, dx, dy, dz, 0.1);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
    }

    @Override
    protected int baseLifetime() {
        return 23;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.HEAL);
        return PlayState.CONTINUE;
    }
}

