/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FrogHealProjectile
extends BaseProjectile {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private LivingEntity target;

    public FrogHealProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(0.5), this::m_5603_);
    }

    protected boolean m_5603_(@NotNull Entity pTarget) {
        if (pTarget == this.m_19749_()) {
            return false;
        }
        return Util.areEntitiesLinked((Entity)this, pTarget);
    }

    public float getDefaultSpeed() {
        return 0.425f;
    }

    public float getDefaultLerp() {
        return 0.28f;
    }

    public void spawnRibbon() {
        Companions.PROXY.spawnGenericRibbonTrail((Entity)this, this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.88235295f, 1.0f, 0.85490197f, 0.0f, 0.35f);
    }

    public void spawnParticles() {
        if (this.f_19797_ % 8 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)KnightLibParticles.STARSET.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void m_8119_() {
        Vec3 v;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.target != null && this.target.m_6084_()) {
            v = this.target.m_146892_().m_82546_(this.m_20182_()).m_82541_().m_82490_((double)this.getDefaultSpeed());
            this.m_20256_(this.m_20184_().m_165921_(v, (double)this.getDefaultLerp()).m_82541_().m_82490_((double)this.getDefaultSpeed()));
            this.f_19812_ = true;
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.m_9236_().f_46443_) {
            v = this.m_20184_();
            this.m_146922_((float)(Mth.m_14136_((double)v.f_82479_, (double)v.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)v.f_82480_, (double)v.m_165924_()) * 57.2957763671875));
        }
        this.spawnParticles();
        if (!this.m_20096_()) {
            Vec3 pos = this.m_20182_();
            Vec3 vec33 = pos.m_82549_(this.m_20184_());
            BlockHitResult hitresult = this.m_9236_().m_45547_(new ClipContext(pos, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityhitresult = this.findHitEntity(pos, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_19749_();
                    if (entity instanceof Player) {
                        Player p2;
                        Player p1 = (Player)entity;
                        if (entity1 instanceof Player && !p1.m_7099_(p2 = (Player)entity1)) {
                            hitresult = null;
                            entityhitresult = null;
                        }
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null) break;
                hitresult = null;
            }
            this.m_20101_();
        }
        if (this.m_20096_()) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_ && (this.f_19797_ % 20 == 0 || this.f_19797_ == 1)) {
            this.spawnRibbon();
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        Entity e = pResult.m_82443_();
        for (int i = 0; i < 20; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.f_46441_.m_188501_() < 0.35f) {
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, e.m_20185_(), e.m_20186_() + 0.15, e.m_20189_(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.f_46441_.m_188501_() < 0.65f)) continue;
            level2.m_8767_((ParticleOptions)((SimpleParticleType)KnightLibParticles.STARSET.get()), e.m_20185_(), e.m_20186_() + 0.15, e.m_20189_(), 1, dx, dy, dz, 0.1);
        }
        if (e instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)e;
            entity.m_5634_((float)CompanionsConfig.ENDER_FROG_HEAL_PROJECTILE_HEAL_AMOUNT);
        }
        this.m_216990_(CompanionsSounds.END_FROG_HEAL.get());
        this.m_146870_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    public void m_6123_(@NotNull Player pEntity) {
    }

    @Override
    protected int baseLifetime() {
        return 200;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }
}

